theory question_89_5

imports Main

begin

typedecl entity
typedecl event

consts
  Triceps :: "entity ⇒ bool"
  Contract :: "event ⇒ bool"
  Can :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Triceps have the ability to contract when targeted during arm exercises. *)
axiomatization where
  explanation_1: "∀x e. Triceps x ∧ TargetedDuringArmExercises x ⟶ (Contract e ∧ Ability e x)"

theorem hypothesis:
  assumes asm: "Triceps x"
  (* Hypothesis: Triceps can only contract. *)
  shows "∃x e. Triceps x ∧ Contract e ∧ Can e x"
proof -
  from asm have "Triceps x" by simp
  then obtain e where e: "Contract e ∧ Ability e x" using explanation_1 by blast
  then have "Can e x" using e by blast
  have conclusion: "Contract e ∧ Can e x" using e by simp
  show ?thesis using asm conclusion by blast
qed

end
