theory question_63_0
imports Main

begin

typedecl entity
typedecl event

consts
  SedimentaryRocks :: "entity ⇒ bool"
  Deposition :: "entity ⇒ bool"
  Formed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Commonest :: "entity ⇒ entity ⇒ bool"
  Sandstone :: "entity"

(* Explanation 1: sedimentary rocks are formed by deposition *)
axiomatization where
  explanation_1: "∀x y e. SedimentaryRocks x ∧ Deposition y ∧ Formed e ∧ Agent e y ∧ Patient e x"

(* Explanation 2: Sedimentary Rocks One of the commonest sedimentary rocks is sandstone. *)
axiomatization where
  explanation_2: "∀x. SedimentaryRocks x ⟶ Commonest x Sandstone"

theorem hypothesis:
  assumes asm: "SedimentaryRocks x ∧ Deposition y"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "∃x y e. SedimentaryRocks x ∧ Deposition y ∧ Formed e ∧ Agent e y ∧ Patient e x ∧ Sandstone x"
proof -
  from asm have "SedimentaryRocks x ∧ Deposition y" by simp
  then obtain e where e: "Formed e ∧ Agent e y ∧ Patient e x" using explanation_1 by blast
  then have "Commonest x Sandstone" using explanation_2 by blast
  have conclusion: "Formed e ∧ Agent e y ∧ Patient e x" using e by simp
  show ?thesis using asm conclusion `Commonest x Sandstone` by blast
qed

end
