theory question_88_0
imports Main

begin
typedecl entity
typedecl event

consts
  Displaying :: "event ⇒ bool"
  Does :: "event ⇒ bool"
  Gymnast :: "entity ⇒ bool"
  Skills :: "entity ⇒ bool"
  Flip :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Flooring :: "entity ⇒ bool"
  Blue :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Displaying skills with a flip is a rephrasing of "does a flip." *)
axiomatization where
  explanation_1: "∀e1 e2. Displaying e1 ⟷ Does e2"

theorem hypothesis:
  (* Premise: Gymnast does a flip on blue flooring. *)
  assumes asm: "Gymnast x ∧ Flip y ∧ Flooring z ∧ Blue z ∧ Does e ∧ Agent e x ∧ Patient e y ∧ On x z"
  (* Hypothesis: A gymnast displays their skills with a flip. *)
  shows "∃x y e. Gymnast x ∧ Skills y ∧ Flip y ∧ Displaying e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Gymnast x ∧ Flip y ∧ Displaying e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
