#no conclusion
def visual_premise_prompt(vps, conclusion=None):
  if conclusion is not None:
      prompt = f"""
Below is an instruction that describes a task. Write a response that appropriately completes the request.

Instruction: <image>\nThe image is about "{conclusion}". Given an image, your task is to choose one visual cue from the below options. Visual cue is an important feature we can perceive in an image.

Options:
{vps}
ANSWER:
"""  

  else:
    prompt = f"""
Below is an instruction that describes a task. Write a response that appropriately completes the request.

Instruction: <image>\nGiven an image, your task is to choose visual cue from the below options. Visual cue is an important feature we can perceive in an image.

Options:
{vps}
ANSWER:
"""  
  return prompt

def visual_premise_prompt1(vps, conclusion=None):
  if conclusion is not None:
      prompt = f"""
Below is an instruction that describes a task. Write a response that appropriately completes the request.

Instruction: <image>\nGiven an image, conclusion, and visual cue options, your task is to select one visual cue from the options. Visual cue is an important feature we can perceive in an image.

Conclusion: {conclusion}
Options:
{vps}
ANSWER:
"""  

  else:
    prompt = f"""
Below is an instruction that describes a task. Write a response that appropriately completes the request.

Instruction: <image>\nGiven an image and visual cue options, your task is to select one visual cue from the options. Visual cue is an important feature we can perceive in an image.

Options:
{vps}
ANSWER:
"""  
  return prompt
   
def visual_premise_prompt2(vps, conclusion=None):
  if conclusion is not None:
      prompt = f"""
Instruction: <image>\nGiven an image, conclusion, and visual cue options, your task is to select one visual cue that is most related to the image from the options. Choose A,B,C,D or E.

Conclusion: {conclusion}
Options:
{vps}
ANSWER:
"""  

  else:
    prompt = f"""
Instruction: <image>\nGiven an image and visual cue options, your task is to select one visual cue from the options.

Options:
{vps}
ANSWER:
"""  
  return prompt


def commonsense_premise_prompt(cps, conclusion=None):
    prompt = f"""
Instruction: Please select the commonsense premise(A,B,C,D, or E) that best relates to the provided image and conclusion.

Image:
<image>

Conclusion: {conclusion}

Options:
{cps}
ANSWER:
"""
    return prompt


def new_visual_premise_prompt(vp_options, conclusion):
   prompt = f"""
Instruction: Given an image, conclusion, and visual cue options, your task is to select one visual cue that is most related to the image and conclusion. Answer A), B), or C) with no additional explanation.

Image:
<image>

Conclusion: {conclusion}
Options:
{vp_options}
ANSWER:"""
   return prompt

def new_visual_premise_prompt_gpt(vp_options, conclusion):
   prompt = f"""
Image:
<image>

Instruction: When given an image, a conclusion, and several visual cue options, you need to identify the visual cue that best relates to the conclusion. To do this effectively, carefully analyze how each visual cue connects to the key elements of the conclusion. Select the visual cue that most directly supports or illustrates the conclusion, ensuring that it enhances the overall understanding and clarity of the message. Answer A), B), or C) with no additional explanation.

Conclusion: {conclusion}
Options:
{vp_options}
ANSWER:"""
   return prompt