# GLAME

Code for ***Knowledge Graph Enhanced Large Language Model Editing***

- `/datasets/` contains the datasets used in the experiments, as well as the corresponding knowledge graph subgraphs that we pre-sampled. 

- `/experiment/` contains the code implementation of the GLAME model, as well as the experimental framework required for other tests. 
- `/wikidata_tools/`  contains the web crawler scripts that we used to acquire graphs from Wikidata.

Note that our GLAME model may be labeled as MEGA in the code implementation.

## Requirements

- At least a GPU with no less than 48G memory is needed.

- For the environment, we use `conda` for managing Python, CUDA, DGL and PyTorch; `pip` is for everything else. To get started, simply install `conda` and run:

```bash
CONDA_HOME=$CONDA_HOME ./scripts/setup_conda.sh
```

`$CONDA_HOME` should be the path to your `conda` installation, e.g., `~/miniconda3`.

## Running the Evaluation

An example for editing GPT-J with GLAME on CounterFact dataset:
```shell
python -m experiments.evaluate_mega \
    --alg_name=MEGA \
    --model_name=[path/to/your/gpt-j/model] \
    --hparams_fname=gpt-j-6b.json \
    --ds_name=cf \
    --num_edits=1
```
Another example for editing GPT-J with GLAME on CounterFactPlus dataset:

```shell
python -m experiments.evaluate_port \
    --alg_name=MEMIT \
    --model_name=[path/to/your/gpt-j/model] \
    --hparams_fname=gpt-j-6b.json \
    --ds_name=cf-one-hop \
    --num_edits=1
```

Computing the covariance matrix estimation $C$ locally is time consuming, but it will be stored after computing and can be directly used in the next run. It will then take a dozen hours to complete the editing and the evaluation.

To summarize the results of CounterFact dataset, use [`experiments/summarize.py`](experiments/summarize.py):

```bash
python -m experiments.summarize --dir_name=MEGA --runs=run_<run1>
```

## Acknowledgement

The code we conduct our experiments is based on [`MEMIT`](https://github.com/kmeng01/memit.git).

