import os
import openai
from tenacity import (
    retry,
    stop_after_attempt, # type: ignore
    wait_random_exponential, # type: ignore
)
import time
from typing import Optional, List, Union

#openai.api_key = os.getenv('OPENAI_API_KEY')
#openai.api_key = ""
API_KEYS = ["",
            ""]
current_key_index = 0

@retry(wait=wait_random_exponential(min=5, max=60), stop=stop_after_attempt(6))
def get_completion(prompt: Union[str, List[str]], max_tokens: int = 256, stop_strs: Optional[List[str]] = None, is_batched: bool = False) -> Union[str, List[str]]:
    global current_key_index

    assert (not is_batched and isinstance(prompt, str)) or (is_batched and isinstance(prompt, list))
    openai.api_key = API_KEYS[current_key_index]
    time.sleep(5)
    response = openai.Completion.create(
        model='code-davinci-002',
        prompt=prompt,
        temperature=0.0,
        max_tokens=max_tokens,
        top_p=1,
        frequency_penalty=0.0,
        presence_penalty=0.0,
        stop=stop_strs,
    )

    current_key_index = (current_key_index + 1) % len(API_KEYS)

    if is_batched:
        res: List[str] = [""] * len(prompt)
        for choice in response.choices:
            res[choice.index] = choice.text
        return res
    return response.choices[0].text


@retry(wait=wait_random_exponential(min=5, max=60), stop=stop_after_attempt(6))
def get_chat_completion(messages: Union[str, List[str]], max_tokens: int = 256, stop_strs: Optional[List[str]] = None, is_batched: bool = False) -> Union[str, List[str]]:
    assert (not is_batched and isinstance(prompt, str)) or (is_batched and isinstance(prompt, list))
    time.sleep(5)
    response = openai.ChatCompletion.create(
        model="gpt-3.5-turbo-0301",
        messages=messages,
        temperature=0.0,
        max_tokens=max_tokens,
        top_p=1,
        n=1,
        frequency_penalty=0.0,
        presence_penalty=0.0,
        stop=stop_strs,
    )
    if is_batched:
        res: List[str] = [""] * len(prompt)
        for choice in response.choices:
            res[choice.index] = choice.text
        return res
    return response.choices[0].text


