from typing import List, Dict
import ipdb

class EnvironmentHistory:
    def __init__(self, base_query: str, start_info, memory: List[str], history: List[Dict[str, str]] = [], world_model: List[str]=[]) -> None:
        self._world_model: List[str] = world_model
        #ipdb.set_trace()
        if len(self._world_model) > 0:            
            # add latest world model if it exists
            self._cur_query: str = f'{_get_base_query(base_query, start_info, memory, self._world_model)}'
        else:
            self._cur_query: str = f'{_get_base_query(base_query, start_info, memory)}'        
        #ipdb.set_trace()

        self._history: List[Dict[str, str]] = history
        self._last_action: str = ''
        self._is_exhausted: bool = False

    def add(self, label: str, value: str) -> None:
        assert label in ['action', 'observation', 'human_edit']
        self._history += [{
            'label': label,
            'value': value,
        }]
        if label == 'action':
            

            if value == self._last_action:
                self._is_exhausted = True
            else:
                self._last_action = value
        
        #"""
        elif label == 'observation':
            if value == "Nothing happens.":
                #self._is_exhausted = True
                # if action does not contain go:
                if "go" not in self._last_action:
                    # This is an action faliure
                    self._is_exhausted = True
                    #ipdb.set_trace()

                #elif "go" in self._last_action:
                    # Rewrite value to be "You're already there."
                    #self._history[-1]['value'] = "You're already there."
        #"""
    
    def add_orig(self, label: str, value: str) -> None:
        assert label in ['action', 'observation', 'human_edit']
        self._history += [{
            'label': label,
            'value': value,
        }]
        if label == 'action':
            if value == self._last_action:
                self._is_exhausted = True
            else:
                self._last_action = value
    
    def remove(self, label: str, value: str) -> None:
        assert label in ['action', 'observation', 'human_edit']
        self._history += [{
            'label': label,
            'value': value,
        }]
        if label == 'action':
            if value == self._last_action:
                self._is_exhausted = True
            else:
                self._last_action = value

    #def add_world_model(self, world_model: str) -> None:

    def check_is_exhausted(self) -> bool:
        return self._is_exhausted

    def reset(self) -> None:
        self._history = []

    def __str__(self, exclude_thoughts=False, exclude_last=0) -> str:
        s: str = self._cur_query + '\n'
        skip_obs = False
        for i, item in enumerate(self._history):
            # skip last n items
            if exclude_last > 0 and i >= len(self._history) - exclude_last:
                continue
                
            if item['label'] == 'action':
                if i > 2:
                    if exclude_thoughts and 'think' in item['value']:
                        skip_obs = True
                        continue
                s += f'> {item["value"]}'
            elif item['label'] == 'observation':
                if skip_obs:
                    skip_obs = False
                    continue
                s += item['value']

            # NOT CURRENTLY SUPPORTED
            elif item['label'] == 'human_edit':
                s += f'[human edit]: {item["value"]}'
            if i != len(self._history) - 1:
                s += '\n'
        return s

    

def _get_base_query(base_query: str, start_info: str, memory: List[str], world_model: List[str]=[]) -> str:
    query = base_query

    # add world model if it exists
    if len(world_model) > 0:
        query += '\n\nYour environment model for the task below:'
        query += f'\n{world_model[-1].strip()}' # use latest world model

    # add memory if it exists
    if len(memory) > 0:
        query += '\n\nYour memory for the task below:'
        for i, m in enumerate(memory):
            query += f'\nTrial {i}:\n{m.strip()}'

    # add world model if it exists
    #if len(world_model) > 0:
    #    query += '\n\nYour environment model for the task below:'
    #    query += f'\n{world_model[-1].strip()}' # use latest world model

    query += f"\nHere is the task:\n{start_info}"
    return query
