export PYTHONPATH="/home/dyhwang/workplace/paper_work/BLINK"
export GPUS=(0 1 2 3 4 5 6 7)
export SEED_A=241
export SEED_B=2836
export SEED_C=12345
export SEED_D=58314
export SEEDS=(${SEED_A} ${SEED_B} ${SEED_C} ${SEED_D})
export RUNS=(a b c d)

export CUDA_VISIBLE_DEVICES=${GPUS[0]}
export SEED=${SEEDS[0]}
export RUN=${RUNS[0]}


export APPROACH="/home/dyhwang/workplace/paper_work/data/zeshel/low-resource"
export INPUT="${APPROACH}"
export OUTPUT="${APPROACH}/${RUN}"

echo "Launching training with SEED=${SEED} for run ${RUN} on GPU ${CUDA_VISIBLE_DEVICES} for approach ${APPROACH}"
python blink/biencoder/train_biencoder.py \
  --data_path ${INPUT} \
  --output_path ${OUTPUT} \
  --learning_rate 1e-05 --num_train_epochs 3 --max_context_length 128 --max_cand_length 128 \
  --train_batch_size 32 --eval_batch_size 32 --bert_model bert-base-uncased \
  --type_optimization all_encoder_layers --data_parallel --print_interval 100 \


