"""A setuptools based setup module.
See:
https://packaging.python.org/guides/distributing-packages-using-setuptools/
https://github.com/pypa/sampleproject
Modified by Madoshakalaka@Github (dependency links added)
"""
# io.open is needed for projects that support Python 2.7
# It ensures open() defaults to text mode with universal newlines,
# and accepts an argument to specify the text encoding
# Python 3 only projects can skip this import
from io import open
from os import path

# Always prefer setuptools over distutils
from setuptools import setup

here = path.abspath(path.dirname(__file__))

# Get the long description from the README file
with open(path.join(here, "README.md"), encoding="utf-8") as f:
    long_description = f.read()

# Arguments marked as "Required" below must be included for upload to PyPI.
# Fields marked as "Optional" may be commented out.

setup(
    name="hedal",
    version="0.0.2",
    description="Homomorphic Encrypted Data Analysis Library",
    packages=["hedal", "hedal.core", "hedal.frame", "hedal.matrix", "hedal.matrix.ops", "hedal.ml"],
    install_requires=[
        "numpy==1.20.3",
        "pandas==1.2.4",
        "pydantic==1.8.2",
        "python-dateutil==2.8.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2'",
        "pytz==2021.1",
        "six==1.16.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2'",
        "typing-extensions==3.10.0.0",
    ],
)
