from ekphrasis.classes.preprocessor import TextPreProcessor
from ekphrasis.classes.tokenizer import SocialTokenizer
from ekphrasis.dicts.emoticons import emoticons
# from transformers import BertTokenizer
import string
import re
import spacy

nlp2 = spacy.load('en_core_web_sm')
from spacy.symbols import ORTH, NORM, LEMMA
import string
from spacy.lang.char_classes import LIST_PUNCT, LIST_ELLIPSES, LIST_QUOTES, \
    LIST_CURRENCY
from spacy.lang.char_classes import LIST_ICONS, HYPHENS, CURRENCY, UNITS
from spacy.lang.char_classes import CONCAT_QUOTES, ALPHA_LOWER, ALPHA_UPPER, \
    ALPHA, PUNCT
from spacy.util import compile_infix_regex, compile_prefix_regex, \
    compile_suffix_regex

##### text preprocessor for ekphrasis
text_processor = TextPreProcessor(
    # terms that will be normalized
    normalize=['url', 'email', 'percent', 'money', 'phone', 'user',
               'time', 'date', 'number'],
    # terms that will be annotated
    fix_html=True,  # fix HTML tokens
    annotate={"hashtag", "allcaps", "elongated", "repeated",
              'emphasis', 'censored'},
    # corpus from which the word statistics are going to be used
    # for word segmentation
    segmenter="twitter",

    # corpus from which the word statistics are going to be used
    # for spell correction
    # corrector="twitter",

    unpack_hashtags=True,  # perform word segmentation on hashtags
    unpack_contractions=True,  # Unpack contractions (can't -> can not)
    spell_correct_elong=False,  # spell correction for elongated words

    # select a tokenizer. You can use SocialTokenizer, or pass your own
    # the tokenizer, should take as input a string and return a list of tokens
    tokenizer=SocialTokenizer(lowercase=True).tokenize,

    # list of dictionaries, for replacing tokens extracted from the text,
    # with other expressions. You can pass more than one dictionaries.
    dicts=[emoticons]
)


#### Bert tokenizer
def custom_tokenize(sent, tokenizer, max_length=512):
    # `encode` will:
    #   (1) Tokenize the sentence.
    #   (2) Prepend the `[CLS]` token to the start.
    #   (3) Append the `[SEP]` token to the end.
    #   (4) Map tokens to their IDs.
    try:

        encoded_sent = tokenizer.encode(
            sent,  # Sentence to encode.
            add_special_tokens=False,  # Add '[CLS]' and '[SEP]'
            # max_length = max_length,
            # This function also supports truncation and conversion
            # to pytorch tensors, but we need to do padding, so we
            # can't use these features :( .
            # max_length = 128,          # Truncate all sentences.
            # return_tensors = 'pt',     # Return pytorch tensors.
        )

        # Add the encoded sentence to the list.

    except ValueError:
        encoded_sent = tokenizer.encode(
            ' ',  # Sentence to encode.
            add_special_tokens=False,  # Add '[CLS]' and '[SEP]'
            max_length=max_length,

        )
        ### decide what to later

    return encoded_sent


# input: text
# process: ekphrasis preprocesser + some extra processing
# output: list of tokens
def ek_extra_preprocess(text, params, tokenizer):
    remove_words = ['<allcaps>', '</allcaps>', '<hashtag>', '</hashtag>',
                    '<elongated>', '<emphasis>', '<repeated>', '\'', 's']
    word_list = text_processor.pre_process_doc(text)
    if (params['include_special']):
        pass
    else:
        word_list = list(filter(lambda a: a not in remove_words, word_list))
    if (params['bert_tokens']):
        sent = " ".join(word_list)
        sent = re.sub(r"[<\*>]", " ", sent)
        sub_word_list = custom_tokenize(sent, tokenizer)
        return sub_word_list
    else:
        word_list = [token for token in word_list if
                     token not in string.punctuation]
        return word_list


# input: text
# process: remove html tags
# output: text with no html tags
def cleanhtml(raw_html):
    cleanr = re.compile('<.*?>')
    cleantext = re.sub(cleanr, '', raw_html)
    return cleantext


##### Preprocessing queries for raw text not needed for implementation
special_cases = {}
# Times
for h in range(1, 12 + 1):
    for period in ["a.m.", "am"]:
        special_cases["%d%s" % (h, period)] = [
            {ORTH: "%d" % h},
            {ORTH: period, LEMMA: "a.m.", NORM: "a.m."},
        ]
    for period in ["p.m.", "pm"]:
        special_cases["%d%s" % (h, period)] = [
            {ORTH: "%d" % h},
            {ORTH: period, LEMMA: "p.m.", NORM: "p.m."},
        ]

for orth in [
    "a.m.",
    "Adm.",
    "Bros.",
    "co.",
    "Co.",
    "Corp.",
    "D.C.",
    "Dr.",
    "e.g.",
    "E.g.",
    "E.G.",
    "Gen.",
    "Gov.",
    "i.e.",
    "I.e.",
    "I.E.",
    "Inc.",
    "Jr.",
    "Ltd.",
    "Md.",
    "Messrs.",
    "Mo.",
    "Mont.",
    "Mr.",
    "Mrs.",
    "Ms.",
    "p.m.",
    "Ph.D.",
    "Prof.",
    "Rep.",
    "Rev.",
    "Sen.",
    "St.",
    "vs.",
    "v.s.",
]:
    special_cases[orth] = [{ORTH: orth}]


# print (special_cases)


def preProcessing(query):
    queryLower = query.lower()
    if queryLower.startswith('eli5'):
        cutMarker = queryLower.find(' ') + 1
        query = query[cutMarker:]

    nlp2.tokenizer.rules = special_cases

    # simple_url_re = re.compile(r'''^https?://''')
    # nlp2.tokenizer.token_match = {}

    # print(nlp.tokenizer.rules)
    prefixes = (
            ["§", "%", "=", "—", "–", r"\+(?![0-9])"]
            + LIST_PUNCT
            + LIST_ELLIPSES
            + LIST_QUOTES
            + LIST_CURRENCY
            + LIST_ICONS
    )

    suffixes = (
            LIST_PUNCT
            + LIST_ELLIPSES
            + LIST_QUOTES
            + LIST_ICONS
            + ["'s", "'S", "’s", "’S", "—", "–"]
            + [
                r"(?<=[0-9])\+",
                r"(?<=°[FfCcKk])\.",
                r"(?<=[0-9])(?:{c})".format(c=CURRENCY),
                r"(?<=[0-9])(?:{u})".format(u=UNITS),
                r"(?<=[0-9{al}{e}{p}(?:{q})])\.".format(
                    al=ALPHA_LOWER, e=r"%²\-\+", q=CONCAT_QUOTES, p=PUNCT
                ),
                r"(?<=[{au}][{au}])\.".format(au=ALPHA_UPPER),
            ]
    )

    infixes = (
            LIST_ELLIPSES
            + LIST_ICONS
            + [
                r"(?<=[0-9])[+\-\*^](?=[0-9-])",
                r"(?<=[{al}{q}])\.(?=[{au}{q}])".format(
                    al=ALPHA_LOWER, au=ALPHA_UPPER, q=CONCAT_QUOTES
                ),
                r"(?<=[{a}]),(?=[{a}])".format(a=ALPHA),
                # r"(?<=[{a}])(?:{h})(?=[{a}])".format(a=ALPHA, h=HYPHENS),
                r"(?<=[{a}0-9])[:<>=/](?=[{a}])".format(a=ALPHA),
            ]
    )

    prefixes_re = compile_prefix_regex(prefixes)
    nlp2.tokenizer.prefix_search = prefixes_re.search

    suffixes_re = compile_suffix_regex(suffixes)
    nlp2.tokenizer.suffix_search = suffixes_re.search

    infix_re = compile_infix_regex(infixes)
    nlp2.tokenizer.infix_finditer = infix_re.finditer

    query = query.replace('\n', ' ')
    query = query.replace('\t', ' ')
    query = re.sub(r'(\w\w)\?(\w\w)', r'\1 ? \2', query)
    query = query.replace('(', ' ( ')
    query = query.replace(')', ' ) ')
    query = query.replace('   ', ' ')
    query = query.replace('  ', ' ')

    doc = nlp2(query)  # , disable=['parser', 'ner'])
    tokens = []
    for token in doc:
        if token.text != ' ':
            tokens.append(token.text)

    if len(tokens) == 0:
        print("Zero token sentence detected!")
    return tokens
