export CUDA_VISIBLE_DEVICES=0
export DATA_DIR=/home/LAB/chenty/workspace/public_dataset/CONLL2003
export TASK_NAME=QQP
export MODEL_PATH=/home/LAB/chenty/workspace/public_models/bert-tiny/bert-tiny.pt
export CONFIG_NAME=/home/LAB/chenty/workspace/public_models/bert-tiny/bert_config_relu.json
export CKPT_PATH=/home/LAB/chenty/workspace/personal/MSRA_project/encryption/unilm2-he/models/CONLL2003_softmax_approximation/pytorch_model.bin
export OUTPUT_DIR=/home/LAB/chenty/workspace/personal/MSRA_project/encryption/unilm2-he/models/CONLL2003_softmax_approximation_ln
export STEPS=880

python nlu_finetune/run_ner_HE.py \
  --config_name ${CONFIG_NAME} \
  --tokenizer_name unilm2-base-uncased \
  --model_name_or_path ${CKPT_PATH} \
  --do_lower_case \
  --task_name ${TASK_NAME} \
  --labels CONLL2003 \
  --do_train \
  --do_eval \
  --app_ln_layer\
  --app_ln_loss \
  --data_dir ${DATA_DIR} \
  --max_seq_length 128 \
  --per_gpu_train_batch_size 16 \
  --per_gpu_eval_batch_size 128 \
  --learning_rate 6e-5 \
  --num_train_epochs 300.0 \
  --save_steps 30000 \
  --logging_steps ${STEPS} \
  --overwrite_output_dir \
  --output_dir ${OUTPUT_DIR} 
