# -*- coding: utf-8 -*-
import tensorflow as tf
import sys
import os

# tf.compat.v1.disable_eager_execution()
cwd = os.getcwd()
sys.path.append(os.path.abspath(os.path.join(cwd, os.pardir)))

with tf.device("/cpu:0"):
    import initialization

    optimizer = initialization.optimizer()
    model = initialization.trainer()
    model.compile(optimizer=optimizer)
    train_data, data_manager = initialization.preprocessed_dataset(1)
    try:
        #get from https://github.com/baridfor3/checkpoint.git#
        model.load_weights(tf.train.latest_checkpoint("./model_checkpoint/"))
    except Exception:
        pass
    for index, inputs in enumerate(train_data.take(1)):
        ########################################  general usage ######################################################3
        from UNIVERSAL.basic_metric import bleu_metric
        # src
        m_real_x = data_manager.encode(
            "The system is fitted with coloured LEDs, which are bright enough that drivers can easily see the lights, even when the sun is low in the sky.[EOS]"
        )
        # reference
        reference = data_manager.encode(
            "Die Anlage ist mit farbigen LEDs ausgestattet, die so kräftig leuchten, dass die Lichter von den Autofahrern beispielsweise auch bei tiefstehender Sonne gut zu erkennen sind.[EOS]"
        )
        # enc: inferring steps in the encoder
        # dec: inferring steps in the encoder
        tgt = model.call([m_real_x], training=False, sos=1, eos=2,enc=6, dec=6)
        bleu = bleu_metric.compute_bleu([reference], tgt.numpy(), eos_id=2)
        ########################################  A example of zero-shot inferring seaching ######################################################3
        # import pdb
        # pdb.set_trace()

        # m_real_x = data_manager.encode(
        #     "The system is fitted with coloured LEDs, which are bright enough that drivers can easily see the lights, even when the sun is low in the sky.[EOS]"
        # )
        # reference = data_manager.encode(
        #     "Die Anlage ist mit farbigen LEDs ausgestattet, die so kräftig leuchten, dass die Lichter von den Autofahrern beispielsweise auch bei tiefstehender Sonne gut zu erkennen sind.[EOS]"
        # )
        # for i in range(1, 7):
        #     for j in range(1, 7):
        #         tgt = model.call([m_real_x], training=False, sos=1, eos=2, enc=i, dec=j)
        #         bleu = bleu_metric.compute_bleu([reference], tgt.numpy(), eos_id=2)
        #         print(bleu)

        ##############################A example of generating json file for visualization #######################################################
        # m_real_x = data_manager.encode(
        #     "The system is fitted with coloured LEDs, which are bright enough that drivers can easily see the lights, even when the sun is low in the sky.[EOS]"
        # )
        # reference = data_manager.encode(
        #     "Die Anlage ist mit farbigen LEDs ausgestattet, die so kräftig leuchten, dass die Lichter von den Autofahrern beispielsweise auch bei tiefstehender Sonne gut zu erkennen sind.[EOS]"
        # )
        # de_real_y = tf.pad([reference], [[0, 0], [1, 0]], constant_values=1)[:, :-1]
        # # tgt = model.train_step(inputs)
        # tgt = model.call(([m_real_x], de_real_y), training=True, sos=1, eos=2, vis=True)
        ######################################################################################################