#!/bin/bash

PREFIX=${PREFIX:?Missing PREFIX env var}
SRC=${SRC:?Missing SOURCE env var}
FORCE=${FORCE:-no}

alphas="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
min_supports="10 20 30"
dimensions="50 100 200 300"

# Check if any of the destination directories exists
if [[ "$FORCE" != "yes" ]]; then
    echo "Checking for existing directories" >&2
    for alpha in $alphas; do
        for min_support in $min_supports; do
            for dimension in $dimensions; do
                d="$PREFIX--alpha_$alpha--minsup_$min_support--dim_$dimension"
                if [[ -e "$d" ]]; then
                    echo Directory \""$d"\" exists. Use the environment variable FORCE=yes in order to allow overwrites >&2
                    exit 1
                fi
            done
        done
    done
fi

echo "Working" >&2
for alpha in $alphas; do
    for min_support in $min_supports; do
        for dimension in $dimensions; do
            d="$PREFIX--alpha_$alpha--minsup_$min_support--dim_$dimension"
            rm -rf "$d"
            mkdir -p "$d"
            cp -a "$SRC/"* "$d"
            cat <<EOF > "$d/conf/embedding_params.py"
KEYWORDS = {
    'dimension': $dimension,
    'alpha': $alpha,
    'min_support': $min_support,
}
EOF

            cat "$d/conf/conf.py" \
              | awk '
                    /^EMBEDDING_METHOD\s*=/ {
                        print "EMBEDDING_METHOD = '"'"'PatternsProbabilities'"'"'";
                        matched=1;
                        next;
                    }
                    {print}
                    END {
                        if (!matched) {
                            print "EMBEDDING_METHOD = '"'"'PatternsProbabilities'"'"'";
                        }
                    }
                ' > "$d/conf/conf.py.new"
            mv "$d/conf/conf.py.new" "$d/conf/conf.py"
        done
    done
done
echo "Done" >&2
