import React, { Component } from 'react';
import { withTracker } from 'meteor/react-meteor-data';
import { Random } from 'meteor/random'

import { gup } from '../util/gup.js';

import SentimentSlider from './SentimentSlider.jsx';

export default class SentimentTask extends Component {
  constructor(props) {
    super(props);

    this.state = {
      edited: new Set(),
    };

    this.notifyOfUpdate = this.notifyOfUpdate.bind(this);
  }

  notifyOfUpdate(taskNum) {
    this.setState((state, props) => {
      const nEdited = new Set(state.edited).add(taskNum)
      if (nEdited.size == 10) {
        this.props.validate();
      }
      return {
        edited: nEdited
      }
    });
  }

  render() {

    const examples = [
      "among cinema 's finest this year",
      "'s a pretty woman",
      "of bad animation and mindless violence",
      "small-budget",
      "delusions to escape their maudlin influence .",
      "Suffers from a flat script and a low budget",
      "skillful and",
      "standard romantic comedy",
      "of 2",
      "of breathtaking mystery",
    ];

    const sliders = examples.map((example, index) => {
      return (
          <SentimentSlider
            key={index}
            sentimentTaskNum={index}
            example={example}
            text={this.props.text}
            ann_id={this.props.ann_id}
            updateValue={this.notifyOfUpdate}
            readOnly={this.props.readOnly}
            clusters={this.props.clusters}
          />
      );
    });

    return (
      <div>
        <h1>
          <span className="sentiment-blue">Sentiment Evaluation for Excerpts from Movie Reviews</span>
        </h1>
        <ul>
          <li>In this study, we want to learn how speakers convey emotional information in language.</li>
          <li>For each given phrase, please rate its sentiment on a scale from <span className='sentiment-purple'>Very Negative</span> to <span className='sentiment-purple'>Very Positive</span>.</li>
          <li>Some of the judgments will be natural. For instance, "awesome movies and books" is a very positive phrase.</li>
          <li>It is possible for a phrase to have a <span className='sentiment-purple'>neutral</span> sentiment. For example, "the newspaper", "and every book", or "We" would be considered as neutral.</li>
          <li>These phrases are taken from movie reviews.</li>
          <li><span className='sentiment-bold'>Please click on the slide bars even when your rating for the phrase is neutral.</span> The change in color of the slide bar indicates that our system has recorded your answer.</li>
          <li>Your submission may be rejected if you do not click on all the slide bars as instructed. It is important that you click on the slide bar once even though you think the phrase is neutral.</li>
          <li>This task is highly subjective. In general, we don't have a right answer in mind, but we will be doing some minimal checking for attentiveness of the examples.</li>
        </ul>

        <h3><span className="sentiment-blue">Please choose the sentiments that best describe the following phrases:</span></h3>
      The change in color of the background indicates that your answer has been recorded.

        {sliders}

        <ul>
          <li>The submit button will only work once you have rated all the phrases.</li>
          <li>For the phrases you want to rate as neutral, you still have to explicitly click on the slider bar.</li>
          <li>Please re-read the instruction for clarification.</li>
        </ul>
      </div>
    );
  }
}

