/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.ArrayList;
import java.util.List;
import simplenlg.aggregation.PhraseSet;
import simplenlg.features.DiscourseFunction;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.VPPhraseSpec;

public abstract class PhraseChecker {
    public static boolean sameSentences(SPhraseSpec ... sentences) {
        boolean equal = false;
        if (sentences.length >= 2) {
            for (int i = 1; i < sentences.length; ++i) {
                equal = sentences[i - 1].equals(sentences[i]);
            }
        }
        return equal;
    }

    public static boolean areNotCoordinate(SPhraseSpec ... sentences) {
        boolean notCoord = true;
        for (int i = 0; i < sentences.length; ++i) {
            notCoord = !sentences[i].isCoordinate();
        }
        return notCoord;
    }

    public static boolean sameFrontMods(SPhraseSpec ... sentences) {
        boolean equal = true;
        if (sentences.length >= 2) {
            for (int i = 1; i < sentences.length && equal; ++i) {
                equal = !sentences[i - 1].hasCuePhrase() && !sentences[i].hasCuePhrase() ? sentences[i - 1].getFrontModifiers().equals(sentences[i].getFrontModifiers()) : (sentences[i - 1].hasCuePhrase() && sentences[i].hasCuePhrase() ? sentences[i - 1].getFrontModifiers().equals(sentences[i].getFrontModifiers()) && sentences[i].getCuePhrase().equals(sentences[i - 1].getCuePhrase()) : false);
            }
        }
        return equal;
    }

    public static boolean sameSubjects(SPhraseSpec ... sentences) {
        boolean equal = sentences.length >= 2;
        for (int i = 1; i < sentences.length && equal; ++i) {
            equal = sentences[i - 1].getSubjects().equals(sentences[i].getSubjects());
        }
        return equal;
    }

    public static boolean samePassiveRaisingSubjects(SPhraseSpec ... sentences) {
        boolean samePassiveSubjects = sentences.length >= 2;
        for (int i = 1; i < sentences.length && samePassiveSubjects; ++i) {
            VPPhraseSpec vp1 = sentences[i - 1].getVerbPhrase();
            VPPhraseSpec vp2 = sentences[i].getVerbPhrase();
            samePassiveSubjects = vp1.getPassiveRaisingComplements().equals(vp2.getPassiveRaisingComplements());
        }
        return samePassiveSubjects;
    }

    public static boolean allPassive(SPhraseSpec ... sentences) {
        boolean passive = true;
        for (int i = 0; i < sentences.length && passive; ++i) {
            passive = sentences[i].isPassive();
        }
        return passive;
    }

    public static boolean allActive(SPhraseSpec ... sentences) {
        boolean active = true;
        for (int i = 0; i < sentences.length && active; ++i) {
            active = !sentences[i].isPassive();
        }
        return active;
    }

    public static boolean sameSurfaceSubjects(SPhraseSpec ... sentences) {
        return PhraseChecker.allActive(sentences) && PhraseChecker.sameSubjects(sentences) || PhraseChecker.allPassive(sentences) && PhraseChecker.samePassiveRaisingSubjects(sentences);
    }

    public static boolean sameVPHead(SPhraseSpec ... sentences) {
        boolean equal = sentences.length >= 2;
        for (int i = 1; i < sentences.length && equal; ++i) {
            VPPhraseSpec vp1 = sentences[i - 1].getVerbPhrase();
            VPPhraseSpec vp2 = sentences[i].getVerbPhrase();
            if (vp1 != null && vp2 != null) {
                Verb h1 = (Verb)vp1.getHead();
                Verb h2 = (Verb)vp2.getHead();
                equal = h1 != null && h2 != null ? h1.equals(h2) : false;
                continue;
            }
            equal = false;
        }
        return equal;
    }

    public static boolean haveSameVoice(SPhraseSpec ... sentences) {
        boolean samePassive = true;
        boolean prevIsPassive = false;
        if (sentences.length > 1) {
            prevIsPassive = sentences[0].isPassive();
            for (int i = 1; i < sentences.length && samePassive; ++i) {
                samePassive = sentences[i].isPassive() == prevIsPassive;
            }
        }
        return samePassive;
    }

    public static boolean areNotExistential(SPhraseSpec ... sentences) {
        boolean notex = true;
        for (int i = 0; i < sentences.length && notex; ++i) {
            notex = !sentences[i].isExistential();
        }
        return notex;
    }

    public static boolean sameVP(SPhraseSpec ... sentences) {
        boolean equal = sentences.length >= 2;
        for (int i = 1; i < sentences.length && equal; ++i) {
            equal = sentences[i - 1].getVerbPhrase().equals(sentences[i].getVerbPhrase());
        }
        return equal;
    }

    public static boolean sameVPArgs(SPhraseSpec ... sentences) {
        boolean equal = sentences.length >= 2;
        for (int i = 1; i < sentences.length && equal; ++i) {
            VPPhraseSpec vp1 = sentences[i - 1].getVerbPhrase();
            VPPhraseSpec vp2 = sentences[i].getVerbPhrase();
            equal = vp1.getComplements().equals(vp2.getComplements());
        }
        return equal;
    }

    public static boolean sameVPModifiers(SPhraseSpec ... sentences) {
        boolean equal = sentences.length >= 2;
        for (int i = 1; i < sentences.length && equal; ++i) {
            VPPhraseSpec vp1 = sentences[i - 1].getVerbPhrase();
            VPPhraseSpec vp2 = sentences[i].getVerbPhrase();
            equal = vp1.getPostmodifiers().equals(vp2.getPostmodifiers()) && vp1.getPremodifiers().equals(vp2.getPremodifiers()) && vp1.getAttributivePostmodifiers().equals(vp2.getAttributivePostmodifiers());
        }
        return equal;
    }

    public static List<PhraseSet> leftPeriphery(SPhraseSpec ... sentences) {
        ArrayList<PhraseSet> funcsets = new ArrayList<PhraseSet>();
        PhraseSet cue = new PhraseSet(DiscourseFunction.CUE_PHRASE, new Phrase[0]);
        PhraseSet front = new PhraseSet(DiscourseFunction.FRONT_MODIFIER, new Phrase[0]);
        PhraseSet subj = new PhraseSet(DiscourseFunction.SUBJECT, new Phrase[0]);
        for (SPhraseSpec s : sentences) {
            if (s.hasCuePhrase()) {
                cue.addPhrase(s.getCuePhrase());
            }
            if (s.hasFrontModifiers()) {
                front.addPhrases(s.getFrontModifiers());
            }
            if (!s.hasSubject()) continue;
            subj.addPhrases(s.getSubjects());
        }
        funcsets.add(cue);
        funcsets.add(front);
        funcsets.add(subj);
        return funcsets;
    }

    public static List<PhraseSet> rightPeriphery(SPhraseSpec ... sentences) {
        ArrayList<PhraseSet> funcsets = new ArrayList<PhraseSet>();
        PhraseSet comps = new PhraseSet(DiscourseFunction.OBJECT, new Phrase[0]);
        new PhraseSet(DiscourseFunction.INDIRECT_OBJECT, new Phrase[0]);
        PhraseSet pmods = new PhraseSet(DiscourseFunction.POSTMODIFIER, new Phrase[0]);
        for (SPhraseSpec s : sentences) {
            if (s.hasComplements()) {
                comps.addPhrases(s.getComplements());
            }
            if (!s.hasPostmodifiers()) continue;
            pmods.addPhrases(s.getPostmodifiers());
        }
        funcsets.add(comps);
        funcsets.add(pmods);
        return funcsets;
    }
}

