#ifndef INCLUDED_MODEL_
#define INCLUDED_MODEL_

#include "../lookup/lookup.h"
#include "../w2v/w2v.h"
#include "../aspgen/aspgen.h"
#include "../ngram/ngram.h"
#include "../ranger/Forest.h"
#include "../vocab/vocab.h"
#include "../headers/config.h"
#include "../parser/parser.h"
#include "../evalb/evalb.h"

#include <string>
#include <unordered_map>
#include <vector>
#include <fstream>

class Model
{
    // perm data
    Parser d_parser;
    Config *d_config;
    w2v d_w2v;
    AspGen d_asp;
    NGram d_twitter;
    NGram d_google;
    Vocab d_knowns;
    Vocab d_dict;
    Vocab d_nes;
    Lookup d_lookup;
    Evalb d_evalb;
    std::ifstream d_treebank;
    Forest *d_forest;

    // Original data
    std::vector<std::string> d_origs;
    std::vector<std::string> d_cors;

    // Resulting data
    std::vector<std::vector<std::string>> d_cands;
    std::vector<std::vector<double>> d_featVals;
    std::vector<std::vector<double>> d_results;

    // data per word
    std::unordered_map<std::string, size_t> d_curCands;
    size_t d_featIdx;
    size_t d_wordIdx;

    public:
        Model(Config *config);

        void train(std::string const &in, std::ostream *out);
        void test(std::istream *in, std::ostream *out, size_t skip=0, size_t numTest = 0);
        void run(std::istream *in, std::ostream *out);
        void interactive();

    private:
        // input data
        bool readRaw(std::istream *input);
        bool readGold(std::istream *input);
        bool consider();
        bool isWord(std::string const &word);
        std::vector<std::string> tokenize(const std::string &source, const std::string &del);

        // generate features
        void gen();
        void addCands(std::string const *cands, double const *vals, size_t const numCands);
        void addNgrams(NGram *langModel);
        void addDictLookup(std::string const &origWord);
        void addGold();
        void genLookup(std::istream *in, size_t numSents);
        bool match(std::string const &orig, std::string const &cand);
        void writeFeats(std::ofstream *out);

        // evaluation/output
        void rank();
        void sortCands();

        void eval();
        void evalNorm();
        void evalParse();

        void writeEval(std::ostream *out);
        void write(std::ostream *out);
        std::string toFsa();
};

#endif
