/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.dualdecomp;

import edu.pku.coli.dualdecomp.AbstractDecoder;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ThirdOrderArgumentCentricDecoder
extends AbstractDecoder {
    private static final long serialVersionUID = -5320042677001375997L;

    public ThirdOrderArgumentCentricDecoder() {
        this.featureExtractor = new FeatureExtractor();
    }

    @Override
    public SentenceForDAGParsing toDAGSentence(SentenceForDAGParsing sent, int[][] var) {
        int sentLen = sent.numOfWords();
        PredicateArgumentAdjunctDAG sys = new PredicateArgumentAdjunctDAG(sentLen);
        int i = 0;
        while (i < sentLen) {
            int j = 0;
            while (j <= sentLen) {
                if (var[i][j] == 1) {
                    sys.addArc(j, i + 1, "X");
                }
                ++j;
            }
            ++i;
        }
        sent.setPredictedDAG(sys);
        return sent;
    }

    @Override
    public int[][] toVariable(SentenceForDAGParsing sent) {
        int sentLen = sent.numOfWords();
        int[][] var = new int[sentLen][sentLen + 1];
        PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
        for (Pair<Integer, Integer> arc : dag.toUnlabeledPairs()) {
            var[arc.getSecond().intValue() - 1][arc.getFirst().intValue()] = 1;
        }
        return var;
    }

    @Override
    public int[][] decodeVariable(final SentenceForDAGParsing sent, final float[] param, final double[][] additionalWeight) {
        final FeatureExtractor fe = (FeatureExtractor)this.featureExtractor;
        int sentLen = sent.numOfWords();
        int[][] var = new int[sentLen][sentLen + 1];
        double totalScore = 0.0;
        int i = 1;
        while (i <= sentLen) {
            int k;
            int l;
            int k2;
            double[][][] scores = new double[sentLen + 2][sentLen + 3][sentLen + 2];
            ExecutorService es = Executors.newFixedThreadPool(this.threadNum);
            ExecutorCompletionService<Double> group = new ExecutorCompletionService<Double>(es);
            Future[][][] results = new Future[sentLen + 2][sentLen + 3][sentLen + 2];
            int j = 0;
            while (j < sentLen + 2) {
                k2 = j;
                while (k2 < sentLen + 3) {
                    l = k2 - 1;
                    while (l < sentLen + 2) {
                        final int fi = i;
                        final int fj = j;
                        final int fk = k2;
                        final int fl = l;
                        if (!(fj == fk && fj != 0 || fk - 1 == fl && fk != sentLen + 2 || fl < 0)) {
                            results[j][k2][l] = group.submit(new Callable<Double>(){

                                @Override
                                public Double call() {
                                    return fe.scoreParents(fi, fj - 1, fk - 1, fl, sent, additionalWeight, param);
                                }
                            });
                        }
                        ++l;
                    }
                    ++k2;
                }
                ++j;
            }
            es.shutdown();
            j = 0;
            while (j < sentLen + 2) {
                k2 = j;
                while (k2 < sentLen + 3) {
                    l = k2 - 1;
                    while (l < sentLen + 2) {
                        if (l >= 0 && results[j][k2][l] != null) {
                            try {
                                scores[j][k2][l] = (Double)results[j][k2][l].get();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                            catch (ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        ++l;
                    }
                    ++k2;
                }
                ++j;
            }
            int maxSib = Math.min(sentLen, this._maxSibling);
            double[][][] table = new double[maxSib + 3][sentLen + 3][sentLen + 2];
            int[][][] bp = new int[maxSib + 3][sentLen + 3][sentLen + 2];
            int k3 = 0;
            while (k3 < sentLen + 2) {
                table[0][0][k3] = scores[0][0][k3];
                ++k3;
            }
            int j2 = 1;
            while (j2 < sentLen + 3) {
                k = j2 - 1;
                while (k < sentLen + 2) {
                    if (k != j2 - 1 || k == sentLen + 1) {
                        table[1][j2][k] = table[0][0][j2 - 1] + scores[0][j2][k];
                    }
                    ++k;
                }
                ++j2;
            }
            j2 = 2;
            while (j2 < maxSib + 2) {
                k = j2;
                while (k < sentLen + 3) {
                    int l2 = k - 1;
                    while (l2 < sentLen + 2) {
                        if (l2 != k - 1 || l2 == sentLen + 1) {
                            double max = Double.NEGATIVE_INFINITY;
                            int m = j2 - 1;
                            while (m < k) {
                                double s = table[j2 - 1][m][k - 1] + scores[m][k][l2];
                                if (s > max) {
                                    max = s;
                                    bp[j2][k][l2] = m;
                                }
                                ++m;
                            }
                            table[j2][k][l2] = max;
                        }
                        ++l2;
                    }
                    ++k;
                }
                ++j2;
            }
            double max = Double.NEGATIVE_INFINITY;
            int j3 = maxSib + 1;
            while (j3 < sentLen + 2) {
                double s = table[maxSib + 1][j3][sentLen + 1] + scores[j3][sentLen + 2][sentLen + 1];
                if (s > max) {
                    max = s;
                    bp[maxSib + 2][sentLen + 2][sentLen + 1] = j3;
                }
                ++j3;
            }
            table[maxSib + 2][sentLen + 2][sentLen + 1] = max;
            double maxScore = Double.NEGATIVE_INFINITY;
            int nParent = -1;
            int j4 = 1;
            while (j4 < maxSib + 3) {
                if (table[j4][sentLen + 2][sentLen + 1] > maxScore) {
                    nParent = j4;
                    maxScore = table[j4][sentLen + 2][sentLen + 1];
                }
                ++j4;
            }
            int last = bp[nParent][sentLen + 2][sentLen + 1];
            if (nParent != 1) {
                var[i - 1][last - 1] = 1;
                int postLast = sentLen + 1;
                int j5 = nParent - 1;
                while (j5 > 1) {
                    int t = last;
                    last = bp[j5][last][postLast];
                    postLast = t;
                    var[i - 1][last - 1] = 1;
                    --j5;
                }
            }
            totalScore += maxScore;
            ++i;
        }
        return var;
    }

    @Override
    public int[][] decodeAfterScoring(double[][] additionalWeight) {
        return null;
    }

    @Override
    public void scoreFeats(float[] param) {
    }

    class FeatureExtractor
    extends AbstractDecoder.FeatureExtractor {
        private static final long serialVersionUID = 1505705423369818781L;

        FeatureExtractor() {
        }

        @Override
        List<Integer> extract(SentenceForDAGParsing sent, boolean predicted) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int sentLen = sent.numOfWords();
            PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
            if (predicted) {
                dag = sent.getPredictedDAG();
            }
            int i = 1;
            while (i <= sentLen) {
                PredicateArgumentAdjunctDAG.PredicateArgumentAdjunctArcAdjacencyList arcs = dag.getAdjacencyLists()[i];
                List<PredicateArgumentAdjunctDAG.ArcInfo> inArcs = arcs.getInArcs();
                if (!inArcs.isEmpty()) {
                    ret.addAll(this.parentFeats(i, -1, -1, inArcs.get((int)0).index, sent));
                    if (inArcs.size() == 1) {
                        ret.addAll(this.parentFeats(i, -1, inArcs.get((int)0).index, sentLen + 1, sent));
                    } else if (inArcs.size() >= 2) {
                        ret.addAll(this.parentFeats(i, -1, inArcs.get((int)0).index, inArcs.get((int)1).index, sent));
                        int j = 2;
                        while (j < inArcs.size()) {
                            ret.addAll(this.parentFeats(i, inArcs.get((int)(j - 2)).index, inArcs.get((int)(j - 1)).index, inArcs.get((int)j).index, sent));
                            ++j;
                        }
                        ret.addAll(this.parentFeats(i, inArcs.get((int)(inArcs.size() - 2)).index, inArcs.get((int)(inArcs.size() - 1)).index, sentLen + 1, sent));
                    }
                    ret.addAll(this.parentFeats(i, inArcs.get((int)(inArcs.size() - 1)).index, sentLen + 1, sentLen + 1, sent));
                } else {
                    ret.addAll(this.parentFeats(i, -1, -1, sentLen + 1, sent));
                    ret.addAll(this.parentFeats(i, -1, sentLen + 1, sentLen + 1, sent));
                }
                ++i;
            }
            return ret;
        }

        public List<Integer> parentFeats(int dependent, int prevprev, int prev, int cur, SentenceForDAGParsing sent) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int n = 1024;
            int dependentWord = sent.getKthWordIndex(dependent);
            int dependentPos = sent.getKthWordIndex(dependent);
            int preDependentWord = sent.getKthWordIndex(dependent - 1);
            int postDependentWord = sent.getKthWordIndex(dependent + 1);
            int preDependentPos = sent.getKthPosIndex(dependent - 1);
            int postDependentPos = sent.getKthPosIndex(dependent + 1);
            int curWord = sent.getKthWordIndex(cur);
            int curPos = sent.getKthPosIndex(cur);
            int preCurWord = sent.getKthWordIndex(cur - 1);
            int postCurWord = sent.getKthWordIndex(cur + 1);
            int preCurPos = sent.getKthPosIndex(cur - 1);
            int postCurPos = sent.getKthPosIndex(cur + 1);
            int prevWord = sent.getKthWordIndex(prev);
            int prevPos = sent.getKthPosIndex(prev);
            int prePrevWord = sent.getKthWordIndex(prev - 1);
            int postPrevWord = sent.getKthWordIndex(prev + 1);
            int prePrevPos = sent.getKthPosIndex(prev - 1);
            int postPrevPos = sent.getKthPosIndex(prev + 1);
            int prevprevWord = sent.getKthWordIndex(prevprev);
            int prevprevPos = sent.getKthPosIndex(prevprev);
            int prePrevprevWord = sent.getKthWordIndex(prevprev - 1);
            int postPrevprevWord = sent.getKthWordIndex(prevprev + 1);
            int prePrevprevPos = sent.getKthPosIndex(prevprev - 1);
            int postPrevprevPos = sent.getKthPosIndex(prevprev + 1);
            int distCur = dependent - cur;
            int distCurPrev = cur - prev;
            int distPrev = dependent - prev;
            int distPrevprev = prev - prevprev;
            int order = distCur > 0 ? 1 : (distPrev > 0 ? 2 : (dependent - prevprev > 0 ? 3 : 4));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevPos, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, prevprevPos, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, prevprevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, preDependentWord, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, preDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, preDependentWord, preDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, preCurWord, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, preCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, preCurWord, preCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prePrevWord, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prePrevPos, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prePrevWord, prePrevPos, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prePrevprevWord, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prePrevprevPos, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prePrevprevWord, prePrevprevPos, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postDependentWord, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postDependentWord, postDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postCurWord, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postCurWord, postCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postPrevWord, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postPrevPos, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postPrevWord, postPrevPos, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postPrevprevWord, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postPrevprevPos, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postPrevprevWord, prePrevprevPos, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, preDependentWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, preDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, preDependentWord, preDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, preCurWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, preCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, preCurWord, preCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prePrevWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prePrevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prePrevWord, prePrevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prePrevprevWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prePrevprevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prePrevprevWord, prePrevprevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postDependentWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postDependentWord, postDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postCurWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postCurWord, postCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postPrevWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postPrevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postPrevWord, postPrevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postPrevprevWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postPrevprevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, postPrevprevWord, prePrevprevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, curWord, curPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, curWord, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, curPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, curWord, curPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, curWord, curPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, curWord, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, curPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, curPos, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, curPos, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, curWord, curPos, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, curWord, curPos, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, curWord, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, curPos, distCurPrev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, prevprevPos, prevWord, prevPos, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, prevprevPos, prevWord, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, prevprevPos, prevPos, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, prevWord, prevPos, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevPos, prevWord, prevPos, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, prevWord, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevPos, prevPos, distPrevprev));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, prevprevPos, prevWord, prevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, prevprevPos, prevWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, prevprevPos, prevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, prevWord, prevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevPos, prevWord, prevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevWord, prevWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevprevPos, prevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, preDependentWord, preDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, preDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preDependentWord, preDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, postDependentWord, postDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, postDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postDependentWord, postDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, preDependentWord, preDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, preDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preDependentWord, preDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, postDependentWord, postDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, postDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postDependentWord, postDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preCurWord, preCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, preCurWord, preCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, preCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postCurWord, postCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, postCurWord, postCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, postCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preCurWord, preCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, preCurWord, preCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, preCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postCurWord, postCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, postCurWord, postCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, postCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preDependentWord, preDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, preDependentWord, preDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, preDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postDependentWord, postDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, postDependentWord, postDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, postDependentPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preDependentWord, preDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, preDependentWord, preDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, preDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postDependentWord, postDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, postDependentWord, postDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, postDependentPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, preCurWord, preCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, preCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preCurWord, preCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, postCurWord, postCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, postCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postCurWord, postCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postCurPos, distCur));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, preCurWord, preCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, preCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preCurWord, preCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, postCurWord, postCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, postCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postCurWord, postCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postCurPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, prevWord, prevPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, prevWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, prevWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, prevPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, prevPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, prevWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, prevWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, prevPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, prevPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, prevprevWord, prevprevPos, prevWord, prevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, prevprevWord, prevWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, prevprevWord, prevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, prevprevPos, prevWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curWord, prevprevPos, prevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, prevprevWord, prevWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, prevprevWord, prevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, prevprevPos, prevWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, curPos, prevprevPos, prevPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, preCurWord, preCurPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, preCurWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, preCurWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, preCurPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, preCurPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preCurWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preCurWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preCurPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preCurPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, postCurWord, postCurPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, postCurWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, postCurWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, postCurPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, postCurPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postCurWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postCurWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postCurPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postCurPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, preDependentWord, preDependentPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, preDependentWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, preDependentWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, preDependentPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, preDependentPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preDependentWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preDependentWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preDependentPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, preDependentPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, dependentPos, postDependentWord, postDependentPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, postDependentWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, postDependentWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, postDependentPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentWord, postDependentPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postDependentWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postDependentWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postDependentPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, dependentPos, postDependentPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, preCurWord, preCurPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, preCurWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, preCurWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, preCurPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, preCurPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, preCurWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, preCurWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, preCurPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, preCurPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, postCurWord, postCurPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, postCurWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, postCurWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, postCurPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, postCurPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, postCurWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, postCurWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, postCurPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, postCurPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, prePrevWord, prePrevPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prePrevWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prePrevWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prePrevPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prePrevPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, prePrevWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, prePrevWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, prePrevPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, prePrevPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, postPrevWord, postPrevPos, curWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, postPrevWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, postPrevWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, postPrevPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevWord, postPrevPos, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, postPrevWord, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, postPrevWord, curPos, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, postPrevPos, curWord, order));
            ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, prevPos, postPrevPos, curPos, order));
            PredicateArgumentAdjunctDAG tree = sent.getSyntaxTree();
            if (ThirdOrderArgumentCentricDecoder.this.usePathFeat && tree != null && !tree.isEmpty() && cur <= sent.numOfWords()) {
                char p;
                int pos;
                PredicateArgumentAdjunctDAG.ArcInfo parentArc;
                ArrayList<Integer> curToRoot = new ArrayList<Integer>();
                ArrayList<Integer> dependentToRoot = new ArrayList<Integer>();
                int t = cur;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    curToRoot.add(t);
                    t = parentArc.index;
                }
                curToRoot.add(t);
                t = dependent;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    dependentToRoot.add(t);
                    t = parentArc.index;
                }
                dependentToRoot.add(t);
                int leastCommonAncestor = 1;
                while (leastCommonAncestor <= curToRoot.size() && leastCommonAncestor <= dependentToRoot.size() && curToRoot.get(curToRoot.size() - leastCommonAncestor) == dependentToRoot.get(dependentToRoot.size() - leastCommonAncestor)) {
                    ++leastCommonAncestor;
                }
                int pathPoss = n++;
                int pathP = n++;
                int i = 0;
                while (i <= curToRoot.size() - leastCommonAncestor) {
                    pos = sent.getKthPosIndex((Integer)curToRoot.get(i));
                    p = sent.getKthPos((Integer)curToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    ++i;
                }
                pathPoss = -pathPoss;
                pathP = -pathP;
                if (leastCommonAncestor > 1) {
                    int pos2 = sent.getKthPosIndex((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1));
                    char p2 = sent.getKthPos((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1)).charAt(0);
                    pathPoss = 31 * pathPoss + pos2;
                    pathPoss = 31 * pathPoss + SentenceForDAGParsing.posIndexer.size();
                    pathP = 31 * pathP + p2;
                    pathP = 31 * pathP + 255;
                }
                i = dependentToRoot.size() - leastCommonAncestor;
                while (i >= 0) {
                    pos = sent.getKthPosIndex((Integer)dependentToRoot.get(i));
                    p = sent.getKthPos((Integer)dependentToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    --i;
                }
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(pathPoss));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(pathP));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(pathPoss, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(pathP, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathPoss, dependentWord, dependentPos, curWord, curPos, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathPoss, dependentWord, dependentPos, curWord, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathPoss, dependentWord, dependentPos, curPos, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathPoss, dependentWord, curWord, curPos, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathPoss, dependentPos, curWord, curPos, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathPoss, dependentWord, curWord, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathPoss, dependentPos, curPos, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathP, dependentWord, dependentPos, curWord, curPos, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathP, dependentWord, dependentPos, curWord, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathP, dependentWord, dependentPos, curPos, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathP, dependentWord, curWord, curPos, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathP, dependentPos, curWord, curPos, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathP, dependentWord, curWord, distCur));
                ret.add(ThirdOrderArgumentCentricDecoder.this.hashInts(n++, pathP, dependentPos, curPos, distCur));
            }
            return ret;
        }

        public double scoreParents(int dependent, int prevprev, int prev, int cur, SentenceForDAGParsing sent, double[][] additionalWeight, float[] param) {
            double score = ThirdOrderArgumentCentricDecoder.this.score(this.parentFeats(dependent, prevprev, prev, cur, sent), param);
            if (cur <= sent.numOfWords()) {
                score += additionalWeight[dependent - 1][cur];
            }
            return score;
        }
    }
}

