###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################


# cat wsj_0001.trees | perl scripts/rctrees2flattrees.pl

## for each tree...
while ( <> ) {

  ## translate to parens...
  s/\[/\(/g;
  s/\]/\)/g;

  ## for each constituent...
  while ( $_ =~ /\([^\(\)]*\)/ ) {

    ## convert outer parens to braces...
    $_ =~ s/\(([^\(\)]*)\)/{\1}/;

    ########## ADD SED RULES HERE: apply rules to angles (children) within braces (consituent)...
    #print stderr "    $_";
    s/{([^ \/]*)\/([^ ]*) (.*)<([^ \/]*)\/([^ ]*) +([^>]*) *> +<([^ ]*) *([^>]*) *> *}/\3<\4\/\5 \6> {\5\/\2 <\7 \8>}/;
#    s/{[^ \/]*\/[^ ]* *(<.*<.*)}/\1/;
##    s/{([^ \/]*)\/([^ ]*) *<\1\/([^ ]*) ([^>]*)> *<\3\/\2 ([^>]*)> *}/<\1\/\3 \4> <\3\/\2 \5>/;
##    s/{([^ \/]*) *<\1\/([^ ]*) ([^>]*)> *<\2 ([^>]*)> *}/<\1\/\2 \3> <\2 \4>/;
    #print stderr " => $_\n";
    ##########

    ## convert inner angles (if any) to bracks...
    while ($_ =~ /{[^{}]*</) {
      $_ =~ s/({[^{}]*)<([^<>]*)>/\1\[\2\]/;
    }

    ## convert outer braces to angles...
    $_ =~ s/{(.*)}/<\1>/;
  }

  ## finish up...
  $_ =~ s/</[/;
  $_ =~ s/>/]/;

  ## translate to parens again...
  $_ =~ s/\[/\(/g;
  $_ =~ s/\]/\)/g;

  print $_;
}
