###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

#####################################################################
# propArgs.rb
# Tim Miller
# 
# This script works on binarized trees in a top-down fashion to propagate
# argument structure, to emulate some features of lexicalization without
# requiring any changes to the parser.
# Rules of type X -> X NP will be changed to X -> X-argNP NP
# and the same with S.
#
######################################################################

require "scripts/umnlp.rb"

class Tree
  def propArgs

    if @children.size < 1
      return
    end

    ## Get the label for the head of the tree and the left child
    ## - the part before the dash - X for X-argNP...  
    if @head =~ /([^-\^]+)(-[^ ]*)?/
      rootBase = $1
    end
    if @children[0].head =~ /([^-\^]+)(-[^ ]*)?/
      childBase = $1
    end

    if @children.size == 1
      ## downward propagation of time NP
      if @head=~/^([\w]+\!ldelim\!)?(PP[^ ]*|NP[^ ]*|NN[^ ]*)-tmp/ && children[0].head=~/^([\w]+\!ldelim\!)?(NN|NP)/ && !(children[0].head=~/tmp/)
        children[0].head += "-tmp"
      end
      ##### SHOULDN'T BE HERE ANYWAY!!!!!!!!!!
      @children[0].propArgs
      return
    end

    if @children[1].head =~ /([^-\^]+)([-\^][^ ]*)?/
      rChildBase = $1
    end
    if (@children.size>2 && @children[2].head =~ /([^-\^]+)([-\^][^ ]*)?/)
      rrChildBase = $1
    end
    
#    ## downward propagation of time NP
#    if @children.size>=2 && @head=~/^(PP[^ ]*|NP[^ ]*|NN[^ ]*)-tmp/ && rChildBase=~/^NN/ && !(@children[1].head=~/tmp/)
#      @children[1].head += "-tmp"
#    end

    if (rootBase=~/^([\w]+\!ldelim\!)?(NN|VB)/ && rootBase==childBase)
      ## Then propagate label downwards
      @children[0].head += @head.gsub(/^[^-]+(.*)/,'\1')
    #elsif @head=~/^(PP[^ ]*|NP[^ ]*|NN[^ ]*)-tmp/ && children[0].head=~/^NN/ && !(children[0].head=~/tmp/)
    #  children[0].head += "-tmp"      
    end
    if (rootBase=~/^([\w]+\!ldelim\!)?(NN|VB)/ && rootBase==rChildBase)
      @children[1].head += @head.gsub(/^[^-]+(.*)/,'\1')
    #elsif @head=~/^(PP[^ ]*|NP[^ ]*|NN[^ ]*)-tmp/ && children[1].head=~/^NN/ && !(children[1].head=~/tmp/)
    #  children[1].head += "-tmp"
    end
    if (@children.size>2 && rootBase=~/^([\w]+\!ldelim\!)?(NN|VB)/ && rootBase==rrChildBase)
      @children[2].head += @head.gsub(/^[^-]+(.*)/,'\1')
    #elsif @children.size>2 && @head=~/^(PP[^ ]*|NP[^ ]*|NN[^ ]*)-tmp/ && children[2].head=~/^NN/ && !(children[2].head=~/tmp/)
    #  children[2].head += "-tmp"      
    end


    ## downward propagation of time NP
    @children.each { |child|
      if @head=~/^([\w]+\!ldelim\!)?(PP[^ ]*|NP[^ ]*|NN[^ ]*)-tmp/ && child.head=~/^([\w]+\!ldelim\!)?NN/ && !(child.head=~/tmp/)
        child.head += "-tmp"
      end
    }

#    ## Check for S or NP or ADJP or VP complement
#    if @children[1].head =~ /^(S$|Sthat|NP|ADJP|VP|VPto)/  # @children[1].head == "S" or @children[1].head == "NP"
      ## If root and child are same base, then add on tag
      if ( #rootBase == childBase
          ((rootBase=~/^([\w]+\!ldelim\!)?(NP|NN)/   || rootBase==childBase) && childBase=~/^([\w]+\!ldelim\!)?DT/ && @children[1].head=~/^([\w]+\!ldelim\!)?(NN|JJ)/) ||
          ((rootBase=~/^([\w]+\!ldelim\!)?(NP|NN)/   || rootBase==childBase) && childBase=~/^([\w]+\!ldelim\!)?NN/ && @children[1].head=~/^([\w]+\!ldelim\!)?(Sproto|Sto|SBARthat|NP|ADJP|PPof)/) ||
          ((rootBase=~/^([\w]+\!ldelim\!)?(PP|SBAR)/ || rootBase==childBase) && childBase=~/^([\w]+\!ldelim\!)?IN/ && @children[1].head=~/^([\w]+\!ldelim\!)?(S|NP|ADJP)/ ) ||
          ((rootBase=~/^([\w]+\!ldelim\!)?(VP|VB)/   || rootBase==childBase) && childBase=~/^([\w]+\!ldelim\!)?VB/ && @children[1].head=~/^([\w]+\!ldelim\!)?(Sproto|Sto|SBARthat|Sprovbn$|Sprovbg$|S$|Sprovbn-empty|Sprovbg-empty|S-empty|NP|ADJP|VP|PRT)/ ) )
        @children[0].head += "-arg#{rChildBase.sub(/^[\w]+\!ldelim\!/,"")}"  # "-arg#{@children[1].head}"
      end
#    end

    @children.each { |child| child.propArgs }
    
#    @children[0].propArgs
#    @children[1].propArgs
    
  end
end

while(line = gets)
  t = Tree.new(line)
  t.propArgs
  print t.to_s + "\n"
end
