
let list_foreach l f = List.iter f l ;;
let hash_foreach h f = Hashtbl.iter f h ;;


type ('c,'v,'p) t = CPT of ('c,('v,'p)Hashtbl.t)Hashtbl.t
;;


let create n =
  CPT(Hashtbl.create n)
;;

let clear m =
  match m with CPT(h) ->
    Hashtbl.clear h
;;

let set m c v p =
  match m with CPT(h) ->
    if (not (Hashtbl.mem h c)) then Hashtbl.add h c (Hashtbl.create 10);
    let h2 = (Hashtbl.find h c) in
    Hashtbl.replace h2 v p
;;

let add m c v p =
  match m with CPT(h) ->
    if (not (Hashtbl.mem h c)) then Hashtbl.add h c (Hashtbl.create 10);
    let h2 = (Hashtbl.find h c) in
    Hashtbl.replace h2 v (p +. (try Hashtbl.find h2 v with Not_found -> 0.))
;;

let foreach m f =
  match m with CPT(h) ->
    hash_foreach h
      (fun c h2 ->
        hash_foreach h2
           (fun v p ->
             f c v p
           )
      )
;;

let foreach_cond m f =
  match m with CPT(h) ->
    Hashtbl.iter f h
;;

let foreach_given m c f =
  match m with CPT(h) ->
    if Hashtbl.mem h c then
      hash_foreach (Hashtbl.find h c) f
    else ()
;;

(*let get_dist m c =*)
(*  match m with CPT(h) ->*)
(*    try Hashtbl.find h c with Not_found -> m*)
(*;;*)
