
(* #load "str.cmxa";; *)
(* #load "scripts/trees.ml";; *)

open Random
open Str
open String
open Trees


let imax    = (int_of_string (Sys.argv.(1)))-1 ;;
let rseed   = (int_of_string (Sys.argv.(2)))-1 ;;

let idOrH = (if (Array.length Sys.argv) >= 4 then Sys.argv.(3) else "h") ;;

let hAdummy = Hashtbl.create 1000;;
let hMdummy = Hashtbl.create 1000;;
let hLdummy = Hashtbl.create 1000;;
let hHdummy = Hashtbl.create 1000;;
let hAnum = Hashtbl.create 1000;;
let hMnum = Hashtbl.create 1000;;
let hLnum = Hashtbl.create 1000;;
let hHnum = Hashtbl.create 1000;;
let hAdenom = Hashtbl.create 1000;;
let hMdenom = Hashtbl.create 1000;;
let hLdenom = Hashtbl.create 1000;;
let hHdenom = Hashtbl.create 1000;;

(* formatting exception *)
exception WrongFormat of string
;;

Random.init rseed
;;

let rec set_counts = function
    ChildList(f,End) -> set_counts f
  | ChildList(Term(sP),ChildList(t0,ChildList(t1,End))) when string_match (regexp "\\(.*\\):\\(.*\\){\\(.*\\)}\\^\\([LR]\\),\\([0-9]\\)") sP 0 ->
      let lP = matched_group 1 sP in
      let cP = matched_group 2 sP in
      let hP = matched_group 3 sP in
      let uP = matched_group 4 sP in
      let dP = matched_group 5 sP in
      let (l0,c0,h0) = (set_counts t0) in
      let (l1,c1,h1) = (set_counts t1) in
      Hashtbl.replace hMdummy (uP,dP,lP,cP,0,l0,c0,l1,c1) 1.0;
(*      Hashtbl.replace hLdummy (l0,0,0) 1.0;*)
(*      Hashtbl.replace hLdummy (l1,0,0) 1.0;*)
      Hashtbl.replace hLdummy ("l",(if uP="L" then dP else (string_of_int (1 + int_of_string dP))),l0,0,0) 1.0;
      Hashtbl.replace hLdummy ("r",dP,l1,0,0) 1.0;
      (lP,cP,hP)
  | ChildList(Term(sP),ChildList(Term(s),End)) when string_match (regexp "\\(.*\\):\\(.*\\){\\(.*\\)}\\^\\([LR]\\),\\([0-9]\\)") sP 0 ->
      let lP = matched_group 1 sP in
      let cP = matched_group 2 sP in
      let hP = matched_group 3 sP in
      let uP = matched_group 4 sP in
      let dP = matched_group 5 sP in
      Hashtbl.replace hMdummy (uP,dP,lP,cP,0,"-","-","-","-") 1.0;
      Hashtbl.replace hHdummy (cP,0,hP) 1.0;
      (lP,cP,hP)
  | _ -> raise (WrongFormat "")
;;


(* read loop *)
try
  while true do
    let s = input_line stdin in
    let r,t = tree_of_string s in
    let (lP,cP,hP) = set_counts t in
    for iP = 0 to imax do
      Hashtbl.replace hAdummy (lP,cP,iP) 1.0;
    done
  done;
  None
with
  End_of_file -> None
;;


let default_find h k = if Hashtbl.mem h k then Hashtbl.find h k else 0.0
;;


Hashtbl.iter (fun (lP,cP,iP) _ ->
  for iP = 0 to imax do
    let pr = Random.float 1.0 in
    Hashtbl.replace hAnum   (lP,cP,iP) pr;
    Hashtbl.replace hAdenom () ((default_find hAdenom ()) +. pr)
  done
) hAdummy;
Hashtbl.iter (fun (uP,dP,lP,cP,_,l0,c0,l1,c1) _ ->
  for iP = 0 to imax do
    let pr = Random.float 1.0 in
    Hashtbl.replace hMnum   (uP,dP,lP,cP,iP,l0,c0,l1,c1) pr;
    Hashtbl.replace hMdenom (uP,dP,lP,cP,iP) ((default_find hMdenom (uP,dP,lP,cP,iP)) +. pr)
  done
) hMdummy;
Hashtbl.iter (fun (uC,dC,lC,_,_) _ ->
(*Hashtbl.iter (fun (lC,_,_) _ ->*)
  for iP = 0 to imax do
    for iC = 0 to imax do
      let pr = (if lC=idOrH then (if iC=iP then 1.0 else 0.0) else Random.float 1.0) in
(*      Hashtbl.replace hLnum   (lC,iP,iC) pr;*)
(*      Hashtbl.replace hLdenom (lC,iP) ((default_find hLdenom (lC,iP)) +. pr)*)
      Hashtbl.replace hLnum   (uC,dC,lC,iP,iC) pr;
      Hashtbl.replace hLdenom (uC,dC,lC,iP) ((default_find hLdenom (uC,dC,lC,iP)) +. pr)
    done
  done
) hLdummy;
Hashtbl.iter (fun (c,_,h) _ ->
  for i = 0 to imax do
    let pr = Random.float 1.0 in
    Hashtbl.replace hHnum   (c,i,h) pr;
    Hashtbl.replace hHdenom (c,i) ((default_find hHdenom (c,i)) +. pr)
  done
) hHdummy;
;;


(* write loop *)
Hashtbl.iter (fun (lP,cP,iP) pr ->  
  let prDenom = (default_find hAdenom ()) in
  print_endline ("A : "^lP^":"^cP^"{e"^(string_of_int iP)^"} = "^(string_of_float (if (prDenom = 0.0) then 0.0 else (pr /. prDenom))))
) hAnum;
Hashtbl.iter (fun (uP,dP,lP,cP,iP,l0,c0,l1,c1) pr ->  
  let prDenom = (default_find hMdenom (uP,dP,lP,cP,iP)) in
  print_endline ("M "^uP^" "^dP^" "^lP^":"^cP^"{e"^(string_of_int iP)^"} : "^l0^":"^c0^" "^l1^":"^c1^" = "^(string_of_float (if (prDenom = 0.0) then 0.0 else (pr /. prDenom))))
) hMnum;
(* Hashtbl.iter (fun (lC,iP,iC) pr ->  *)
(*   let prDenom = (default_find hLdenom (lC,iP)) in*)
(*   print_endline ("L "^lC^" e"^(string_of_int iP)^" : e"^(string_of_int iC)^" = "^(string_of_float (if (prDenom = 0.0) then 0.0 else (pr /. prDenom))))*)
(* ) hLnum;*)
 Hashtbl.iter (fun (uC,dC,lC,iP,iC) pr ->  
   let prDenom = (default_find hLdenom (uC,dC,lC,iP)) in
   print_endline ("L "^uC^" "^dC^" "^lC^" e"^(string_of_int iP)^" : e"^(string_of_int iC)^" = "^(string_of_float (if (prDenom = 0.0) then 0.0 else (pr /. prDenom))))
 ) hLnum;
Hashtbl.iter (fun (c,i,h) pr ->  
  let prDenom = (default_find hHdenom (c,i)) in
  print_endline ("H "^c^" e"^(string_of_int i)^" : "^h^" = "^(string_of_float (if (prDenom = 0.0) then 0.0 else (pr /. prDenom))))
) hHnum
;;
