package edu.umn.cs.nlp.textproc;

import java.util.*;
import java.util.regex.*;

public class RepairModelBuilder{

    public static void removeCompletedEdited(Tree tree){
    
    }
    
    /* This transform corresponds to the EDITED-BIN transform in Miller 2009 (NAACL)
     */
    public static void fixEdited(Tree tree){
    	Pattern etPatt = Pattern.compile("INTJ|PRN");
    	
        if(tree.isPreterm()){
        	return;
        }
        
        // work our way up... start by recursing...
        for(int i = 0; i < tree.children.size(); i++){
        	fixEdited(tree.children.get(i));
        }
        
        int ind = tree.children.size() - 1;
        while(ind > 0){
        	if(ind > 2 && tree.children.get(ind-3).cat.startsWith("EDITED") &&
           		tree.children.get(ind-3).children.size() == 1 &&
        		tree.children.get(ind-3).children.get(0).cat.startsWith(tree.children.get(ind).cat) &&
        		etPatt.matcher(tree.children.get(ind-2).cat).matches() &&
        		etPatt.matcher(tree.children.get(ind-1).cat).matches()){
        		Tree t = new Tree(tree);
        		t.cat = tree.children.get(ind).cat;
        		t.children.add(tree.children.remove(ind-3));
        		t.children.add(tree.children.remove(ind-3));
        		t.children.add(tree.children.remove(ind-3));
        		t.children.add(tree.children.remove(ind-3));
        		tree.children.add(ind-3,t);
        		ind-=3;
        	}else if(ind > 1 && tree.children.get(ind-2).cat.startsWith("EDITED") &&
           		tree.children.get(ind-2).children.size() == 1 &&
        		tree.children.get(ind-2).children.get(0).cat.startsWith(tree.children.get(ind).cat) &&
        		etPatt.matcher(tree.children.get(ind-1).cat).matches()){
        		Tree t = new Tree(tree);
        		t.cat = tree.children.get(ind).cat;
        		t.children.add(tree.children.remove(ind-2));
        		t.children.add(tree.children.remove(ind-2));
        		t.children.add(tree.children.remove(ind-2));
        		t.children.get(0).cat += t.cat;
        		tree.children.add(ind-2, t);
        		ind-=2;
        	}else if(tree.children.get(ind-1).cat.startsWith("EDITED") &&
        		tree.children.get(ind-1).children.size() == 1 &&
        	   tree.children.get(ind-1).children.get(0).cat.startsWith(tree.children.get(ind).cat)){
        		Tree t = new Tree(tree);
        		t.cat = tree.children.get(ind).cat;
        		t.children.add(tree.children.remove(ind-1));
        		t.children.add(tree.children.remove(ind-1));
        		t.children.get(0).cat += t.cat;
        		tree.children.add(ind-1, t);
        		ind--;
        	}else{
        		ind--;
        	}
        }
    }

    public static void flattenEdited(Tree tree){
        if(tree.children.size() == 0){
            return;
        }else{
            int i = tree.children.size()-1;
            while(i >= 0){
//               System.err.println("Examining subtree: " + tree.children.get(i));
               if(tree.children.get(i).cat.startsWith("EDITED") &&
                  tree.children.get(i).children.get(0).cat.startsWith("EDITED")){
                    if(tree.children.get(i).children.size() == 1){
                        Tree temp = tree.children.get(i).children.get(0);
                        tree.children.remove(i);
                        tree.children.add(i, temp);
                        flattenEdited(tree.children.get(i));
                    }else{
                        int endIndex = tree.children.get(i).children.size()-1;
                        int curIndex = i;
                        while(tree.children.get(curIndex).children.size() > 1){
                            Tree rel = tree.children.get(curIndex).children.remove(tree.children.get(curIndex).children.size()-2);
                            tree.children.add(i, rel);
                            curIndex++;
                        }
                        i = curIndex;
                        flattenEdited(tree.children.get(i));
                    }
               }else{
                  flattenEdited(tree.children.get(i));
                  i--;
               }
               
            }
        }
    }

    public static void glomIntj(Tree tree){
    
    }
    
    public static void glomFillers(Tree tree){
    
    }
    
    /*
    public static void flattenEdited(Tree tree){
        if(tree.children.size() != 0){
            int i = tree.children.size()-1;
            while(i >= 0){
                if(tree.children.get(i).getCat().startsWith("EDITED") &&
                 tree.children.get(i).children.get(0).getCat().startsWith("EDITED") &&
                 tree.children.get(i).children.size() == 1){
                    tree.children.set(i, tree.children.get(i).children.get(0));
                }   
                    
                if(tree.children.get(i).getCat().startsWith("EDITED") &&
                tree.children.get(i).children.get(0).getCat().startsWith("EDITED") &&
                tree.children.get(i).children.size() > 1){
                    Vector<Tree> temp = new Vector<Tree>();
                    while(tree.children.get(i).children.size() > 1){
                      temp.add(tree.children.get(i).children.remove(0));
                    }
                    tree.children.addAll(i, temp);
                    i += temp.size();
                }
                flattenEdited(tree.children.get(i));
                i--;
            }
        }
    }
	*/
    
    public static void main(String[] args){
    	/*
        Scanner scanner = new Scanner(System.in);
        
        // if no arguments are passed in just pass the data through...
        if(args.length == 0){
            while(scanner.hasNextLine()){
                System.out.println(scanner.nextLine());
            }
            System.exit(0);
        }else if(args.length == 1){
            if(args[0].startsWith("-")){
                String ops = args[0].substring(1);
                while(scanner.hasNextLine()){
                    Tree tree = new Tree(scanner.nextLine());
                    for(int i = 0; i < ops.length(); i++){
                        switch(ops.charAt(i)){
                            case 'C': removeCompletedEdited(tree); break;
                            case 'e': fixEdited(tree); break;
                            case 'I': glomIntj(tree); break;
                            case 'P': glomFillers(tree); break;
                            case 'q': flattenEdited(tree); break;
                            default:
                        }
                    }
                    System.out.println(tree);
                }
            }else{
                System.err.println("ERROR: Option not understood: " + args[0]);
            }
        }*/
    	String str = "(S1 (S (CC and) (NP-SBJ (PRP it)) (VP (VBD was) (ADVP (RB really)) (EDITED (RB not)) (RB not) (NP-PRD (ADJP (RB very) (JJ good)) (INTJ (UH uh)) (NN deal)))))";
    	fixEdited(new Tree(str));
    }
}
