/*
 * Decompiled with CFR 0.152.
 */
package babel.util.dict;

import babel.util.language.Language;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.json.JSONObject;

public class GoogleDictionaryCollector {
    protected static final String URL_PREF = "http://www.google.com/dictionary/json?callback=dict_api.callbacks.id100&q=";
    protected static final String URL_SUFF = "&restrict=pr%2Cde&client=te";
    protected static final String ENCODING = "UTF-8";
    protected static byte ESCAPE_CHAR = (byte)37;
    protected String m_referrer;

    public GoogleDictionaryCollector(String referrer) {
        if (referrer == null || referrer.length() == 0) {
            throw new IllegalArgumentException("Referrer must be supplied.");
        }
        this.m_referrer = referrer;
    }

    public void translate(Language from, Language to, String word) throws Exception {
        if (word == null || word.length() == 0 || word.contains(" ")) {
            throw new IllegalArgumentException();
        }
        StringBuilder url = new StringBuilder();
        url.append(URL_PREF);
        url.append(URLEncoder.encode(word, ENCODING));
        url.append("&sl=" + from.toString());
        url.append("&tl=" + to.toString());
        url.append(URL_SUFF);
        JSONObject json = this.retrieveJSON(new URL(url.toString()));
        System.out.println(json.toString());
    }

    public static void main(String[] args) throws Exception {
        GoogleDictionaryCollector collector = new GoogleDictionaryCollector("none");
        collector.translate(Language.ENGLISH, Language.SPANISH, "approach");
    }

    protected JSONObject retrieveJSON(URL url) throws Exception {
        JSONObject jSONObject;
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.setRequestProperty("referer", this.m_referrer);
        uc.setRequestMethod("GET");
        uc.setDoOutput(true);
        try {
            String result = this.inputStreamToString(uc.getInputStream());
            result = result.substring(result.indexOf(123), result.lastIndexOf(125) + 1);
            jSONObject = new JSONObject(result);
        }
        catch (Throwable throwable) {
            try {
                uc.getInputStream().close();
                if (uc.getErrorStream() != null) {
                    uc.getErrorStream().close();
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new Exception("Error retrieving detection result : " + ex.toString(), ex);
            }
        }
        uc.getInputStream().close();
        if (uc.getErrorStream() != null) {
            uc.getErrorStream().close();
        }
        return jSONObject;
    }

    private String inputStreamToString(InputStream inputStream) throws Exception {
        StringBuilder outputBuilder = new StringBuilder();
        try {
            if (inputStream != null) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, ENCODING));
                while ((string = reader.readLine()) != null) {
                    outputBuilder.append(string).append('\n');
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Error reading translation stream : " + ex.toString(), ex);
        }
        return outputBuilder.toString();
    }
}

