/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.syntaxgraph.feature;

import java.util.Set;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.FeatureException;
import org.maltparser.core.feature.function.AddressFunction;
import org.maltparser.core.feature.value.AddressValue;
import org.maltparser.core.io.dataformat.DataFormatInstance;
import org.maltparser.core.symbol.SymbolTableHandler;
import org.maltparser.core.symbol.nullvalue.NullValues;
import org.maltparser.core.syntaxgraph.SyntaxGraphException;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.feature.ColumnFeature;
import org.maltparser.core.syntaxgraph.feature.InputArcFeature;
import org.maltparser.core.syntaxgraph.node.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputArcRelated
extends ColumnFeature {
    protected AddressFunction addressFunction1;
    protected AddressFunction addressFunction2;
    protected DataFormatInstance dataFormatInstance;

    public OutputArcRelated(DataFormatInstance dataFormatInstance, SymbolTableHandler tableHandler) throws MaltChainedException {
        this.setDataFormatInstance(dataFormatInstance);
    }

    @Override
    public void initialize(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 3) {
            throw new FeatureException("Could not initialize OutputArcRelated: number of arguments are not correct. ");
        }
        if (!(arguments[0] instanceof String)) {
            throw new FeatureException("Could not initialize OutputArcRelated: the first argument is not a string. ");
        }
        if (!(arguments[1] instanceof AddressFunction)) {
            throw new SyntaxGraphException("Could not initialize OutputArcRelated: the second argument is not an address function. ");
        }
        if (!(arguments[2] instanceof AddressFunction)) {
            throw new SyntaxGraphException("Could not initialize OutputArcRelated: the third argument is not an address function. ");
        }
        this.setAddressFunction1((AddressFunction)arguments[1]);
        this.setAddressFunction2((AddressFunction)arguments[2]);
        this.setColumn(this.dataFormatInstance.getColumnDescriptionByName((String)arguments[0]));
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class[] paramTypes = new Class[]{String.class, AddressFunction.class, AddressFunction.class};
        return paramTypes;
    }

    @Override
    public void update() throws MaltChainedException {
        AddressValue arg1 = this.addressFunction1.getAddressValue();
        AddressValue arg2 = this.addressFunction2.getAddressValue();
        if (arg1.getAddress() == null || arg2.getAddress() == null) {
            this.featureValue.setCode(this.column.getSymbolTable().getNullValueCode(NullValues.NullValueId.NO_NODE));
            this.featureValue.setSymbol(this.column.getSymbolTable().getNullValueSymbol(NullValues.NullValueId.NO_NODE));
            this.featureValue.setKnown(true);
            this.featureValue.setNullValue(true);
        } else {
            DependencyNode node1 = (DependencyNode)arg1.getAddress();
            DependencyNode node2 = (DependencyNode)arg2.getAddress();
            if (!node1.isRoot() && !node2.isRoot()) {
                if (this.checkIfNodesAreRelated(node1, node2)) {
                    Edge e = this.getEdgeBetween(node1, node2);
                    this.featureValue.setCode(e.getLabelCode(this.column.getSymbolTable()));
                    this.featureValue.setSymbol(this.column.getSymbolTable().getSymbolCodeToString(e.getLabelCode(this.column.getSymbolTable())));
                    this.featureValue.setKnown(this.column.getSymbolTable().getKnown(e.getLabelCode(this.column.getSymbolTable())));
                    this.featureValue.setNullValue(false);
                } else {
                    this.featureValue.setCode(this.column.getSymbolTable().getNullValueCode(NullValues.NullValueId.NO_VALUE));
                    this.featureValue.setSymbol(this.column.getSymbolTable().getNullValueSymbol(NullValues.NullValueId.NO_VALUE));
                    this.featureValue.setKnown(true);
                    this.featureValue.setNullValue(true);
                }
            } else {
                this.featureValue.setCode(this.column.getSymbolTable().getNullValueCode(NullValues.NullValueId.ROOT_NODE));
                this.featureValue.setSymbol(this.column.getSymbolTable().getNullValueSymbol(NullValues.NullValueId.ROOT_NODE));
                this.featureValue.setKnown(true);
                this.featureValue.setNullValue(true);
            }
        }
    }

    public AddressFunction getAddressFunction1() {
        return this.addressFunction1;
    }

    public void setAddressFunction1(AddressFunction addressFunction1) {
        this.addressFunction1 = addressFunction1;
    }

    public AddressFunction getAddressFunction2() {
        return this.addressFunction2;
    }

    public void setAddressFunction2(AddressFunction addressFunction2) {
        this.addressFunction2 = addressFunction2;
    }

    public DataFormatInstance getDataFormatInstance() {
        return this.dataFormatInstance;
    }

    public void setDataFormatInstance(DataFormatInstance dataFormatInstance) {
        this.dataFormatInstance = dataFormatInstance;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof InputArcFeature)) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    @Override
    public String toString() {
        return "OutputArcRelated(" + this.column.getName() + ")";
    }

    private boolean checkIfNodesAreRelated(DependencyNode nodo1, DependencyNode nodo2) throws MaltChainedException {
        Set<Edge> arcosNodo2;
        Set<Edge> arcosNodo1 = nodo1.getHeadEdges();
        if (arcosNodo1 != null) {
            for (Edge arco : arcosNodo1) {
                if (arco.getSource().getIndex() != nodo2.getIndex()) continue;
                return true;
            }
        }
        if ((arcosNodo2 = nodo2.getHeadEdges()) != null) {
            for (Edge arco : arcosNodo2) {
                if (arco.getSource().getIndex() != nodo1.getIndex()) continue;
                return true;
            }
        }
        return false;
    }

    private Edge getEdgeBetween(DependencyNode nodo1, DependencyNode nodo2) throws MaltChainedException {
        if (this.checkIfNodesAreRelated(nodo1, nodo2)) {
            Set<Edge> arcosNodo1 = nodo1.getHeadEdges();
            for (Edge arco : arcosNodo1) {
                if (arco.getSource().getIndex() != nodo2.getIndex()) continue;
                return arco;
            }
            Set<Edge> arcosNodo2 = nodo2.getHeadEdges();
            for (Edge arco : arcosNodo2) {
                if (arco.getSource().getIndex() != nodo1.getIndex()) continue;
                return arco;
            }
        }
        return null;
    }
}

