/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus;

import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.ObjectHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XValidatingObjectCorpus<E>
extends Corpus<ObjectHandler<E>>
implements ObjectHandler<E> {
    private final List<E> mItemList = new ArrayList();
    private int mNumFolds;
    private int mFold;

    public XValidatingObjectCorpus(int numFolds) {
        this.setNumFolds(numFolds);
        this.mFold = 0;
    }

    public int numFolds() {
        return this.mNumFolds;
    }

    public void setNumFolds(int numFolds) {
        if (numFolds < 0) {
            String msg = "Number of folds must be non-negative. Found numFolds=" + numFolds;
            throw new IllegalArgumentException(msg);
        }
        this.mNumFolds = numFolds;
    }

    public int fold() {
        return this.mFold;
    }

    public void permuteCorpus(Random random) {
        Collections.shuffle(this.mItemList, random);
    }

    public void setFold(int fold) {
        if (this.mNumFolds == 0) {
            String msg = "Cannot set folds when numFolds() is 0.";
            throw new IllegalArgumentException(msg);
        }
        if (fold < 0 || fold >= this.mNumFolds) {
            String msg = "Fold must be non-negative and less than numFolds. Found numFolds=" + this.mNumFolds + " fold=" + fold;
            throw new IllegalArgumentException(msg);
        }
        this.mFold = fold;
    }

    public int size() {
        return this.mItemList.size();
    }

    @Override
    public void handle(E e) {
        this.mItemList.add(e);
    }

    @Override
    public void visitTrain(ObjectHandler<E> handler) {
        this.handle(handler, 0, this.startTestFold());
        this.handle(handler, this.endTestFold(), this.size());
    }

    @Override
    public void visitTest(ObjectHandler<E> handler) {
        this.handle(handler, this.startTestFold(), this.endTestFold());
    }

    @Override
    public void visitCorpus(ObjectHandler<E> handler) {
        for (E e : this.mItemList) {
            handler.handle(e);
        }
    }

    @Override
    public void visitCorpus(ObjectHandler<E> trainHandler, ObjectHandler<E> testHandler) {
        this.visitTrain(trainHandler);
        this.visitTest(testHandler);
    }

    private void handle(ObjectHandler<E> handler, int start, int end) {
        for (int i = start; i < end; ++i) {
            handler.handle(this.mItemList.get(i));
        }
    }

    private int startTestFold() {
        if (this.mNumFolds == 0) {
            return 0;
        }
        return (int)((double)this.size() * ((double)this.mFold / (double)this.mNumFolds));
    }

    private int endTestFold() {
        if (this.mNumFolds == 0) {
            return 0;
        }
        if (this.mFold == this.mNumFolds - 1) {
            return this.size();
        }
        return (int)((double)this.size() * (((double)this.mFold + 1.0) / (double)this.mNumFolds));
    }
}

