/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.io.Serializable;
import java.util.Arrays;
import settings.Parameters;
import tsg.parser.DerivationElement;
import tsg.parser.DerivationQueue;

public class DerivationForest
implements Serializable {
    private static final long serialVersionUID = 0L;
    int root;
    double logInsideProb;
    int[][] derivations;
    double[] derivationLogProb;

    public DerivationForest(int root, double logProb) {
        this.root = root;
        this.derivations = new int[][]{{-1, -1, -1, -1, -1}};
        this.logInsideProb = logProb;
        this.derivationLogProb = new double[]{logProb};
    }

    public boolean isFull() {
        return this.derivations.length == Parameters.nBest;
    }

    public int size() {
        return this.derivations.length;
    }

    public DerivationForest(int root, DerivationForest uniqueChildForest, double ruleLogProb) {
        this.root = root;
        int derivationSize = uniqueChildForest.derivations.length;
        this.derivations = new int[derivationSize][5];
        this.derivationLogProb = new double[derivationSize];
        this.logInsideProb = uniqueChildForest.logInsideProb + ruleLogProb;
        int i = 0;
        while (i < derivationSize) {
            this.derivations[i] = new int[]{-1, uniqueChildForest.root, i, -1, -1};
            this.derivationLogProb[i] = uniqueChildForest.derivationLogProb[i] + ruleLogProb;
            ++i;
        }
    }

    public DerivationForest(int root, DerivationForest leftForest, DerivationForest upForest, int split, double ruleLogProb) {
        this.root = root;
        int derivationSize = Math.min(Parameters.nBest, leftForest.derivations.length * upForest.derivations.length);
        this.derivations = new int[derivationSize][5];
        this.derivationLogProb = new double[derivationSize];
        this.logInsideProb = leftForest.logInsideProb + upForest.logInsideProb + ruleLogProb;
        int derivationIndex = 0;
        DerivationQueue queue = new DerivationQueue(leftForest, upForest, split);
        DerivationElement topQueueDerivation = queue.pollFirst();
        do {
            this.derivationLogProb[derivationIndex] = topQueueDerivation.logProb + ruleLogProb;
            this.derivations[derivationIndex] = topQueueDerivation.indexes;
            topQueueDerivation = queue.addNeighboursAndPoll(topQueueDerivation);
        } while (++derivationIndex < derivationSize);
    }

    public boolean updateForest(DerivationForest uniqueChildForest, double ruleLogProb) {
        int newDerivationSize;
        this.logInsideProb = Math.log(Math.exp(this.logInsideProb) + Math.exp(uniqueChildForest.logInsideProb + ruleLogProb));
        int currentDerivationIndex = 0;
        int leftDerivationIndex = 0;
        if (this.derivations.length == Parameters.nBest) {
            newDerivationSize = Parameters.nBest;
        } else {
            int completeDerivationSize = this.derivations.length + uniqueChildForest.derivations.length;
            newDerivationSize = Math.min(Parameters.nBest, completeDerivationSize);
        }
        int[][] newDerivations = new int[newDerivationSize][5];
        double[] newDerivationLogProb = new double[newDerivationSize];
        int newDerivationIndex = 0;
        double leftBestDerivationProbPartial = uniqueChildForest.derivationLogProb[0];
        double leftBestDerivationProb = leftBestDerivationProbPartial + ruleLogProb;
        if (leftBestDerivationProb <= this.derivationLogProb[this.derivations.length - 1]) {
            if (this.derivations.length == Parameters.nBest) {
                return false;
            }
            int i = 0;
            while (i < this.derivations.length) {
                newDerivations[i] = this.derivations[i];
                newDerivationLogProb[i] = this.derivationLogProb[i];
                ++i;
            }
            newDerivationIndex = this.derivations.length;
            this.appendLeftDerivations(-1, ruleLogProb, leftDerivationIndex, uniqueChildForest, newDerivations, newDerivationLogProb, newDerivationIndex);
            return true;
        }
        double currentDerivationProb = this.derivationLogProb[currentDerivationIndex];
        do {
            if (leftBestDerivationProb > currentDerivationProb) {
                do {
                    newDerivations[newDerivationIndex] = new int[]{-1, uniqueChildForest.root, leftDerivationIndex++, -1, -1};
                    newDerivationLogProb[newDerivationIndex] = leftBestDerivationProb;
                    ++newDerivationIndex;
                    if (uniqueChildForest.derivations.length != leftDerivationIndex) continue;
                    this.appendCurrentDerivations(currentDerivationIndex, newDerivations, newDerivationLogProb, newDerivationIndex);
                    return true;
                } while ((leftBestDerivationProb = uniqueChildForest.derivationLogProb[leftDerivationIndex] + ruleLogProb) > currentDerivationProb && newDerivationIndex < newDerivationSize);
                continue;
            }
            do {
                newDerivations[newDerivationIndex] = this.derivations[currentDerivationIndex];
                newDerivationLogProb[newDerivationIndex] = this.derivationLogProb[currentDerivationIndex];
                ++newDerivationIndex;
                if (this.derivations.length != ++currentDerivationIndex) continue;
                this.appendLeftDerivations(-1, ruleLogProb, leftDerivationIndex, uniqueChildForest, newDerivations, newDerivationLogProb, newDerivationIndex);
                return true;
            } while (leftBestDerivationProb <= (currentDerivationProb = this.derivationLogProb[currentDerivationIndex]) && newDerivationIndex < newDerivationSize);
        } while (newDerivationIndex < newDerivations.length);
        this.derivations = newDerivations;
        this.derivationLogProb = newDerivationLogProb;
        return true;
    }

    public boolean updateForest(DerivationForest leftForest, DerivationForest upForest, int split, double ruleLogProb) {
        int newDerivationSize;
        this.logInsideProb = Math.log(Math.exp(this.logInsideProb) + Math.exp(leftForest.logInsideProb + upForest.logInsideProb + ruleLogProb));
        int currentDerivationIndex = 0;
        int newDerivationIndex = 0;
        if (this.derivations.length == Parameters.nBest) {
            newDerivationSize = Parameters.nBest;
        } else {
            int completeDerivationSize = this.derivations.length + leftForest.derivations.length * upForest.derivations.length;
            newDerivationSize = Math.min(Parameters.nBest, completeDerivationSize);
        }
        int[][] newDerivations = new int[newDerivationSize][5];
        double[] newDerivationLogProb = new double[newDerivationSize];
        DerivationQueue queue = new DerivationQueue(leftForest, upForest, split);
        DerivationElement topQueueDerivation = queue.pollFirst();
        double topQueueDerivationProb = topQueueDerivation.logProb + ruleLogProb;
        if (topQueueDerivationProb <= this.derivationLogProb[this.derivations.length - 1]) {
            if (this.derivations.length == Parameters.nBest) {
                return false;
            }
            int i = 0;
            while (i < this.derivations.length) {
                newDerivations[i] = this.derivations[i];
                newDerivationLogProb[i] = this.derivationLogProb[i];
                ++i;
            }
            newDerivationIndex = this.derivations.length;
            this.appendQueue(queue, topQueueDerivation, ruleLogProb, newDerivations, newDerivationLogProb, newDerivationIndex);
            return true;
        }
        topQueueDerivationProb = topQueueDerivation.logProb + ruleLogProb;
        double currentDerivationProb = this.derivationLogProb[currentDerivationIndex];
        do {
            if (topQueueDerivation == null) {
                this.appendCurrentDerivations(currentDerivationIndex, newDerivations, newDerivationLogProb, newDerivationIndex);
                return true;
            }
            if (topQueueDerivationProb > currentDerivationProb) {
                do {
                    newDerivations[newDerivationIndex] = topQueueDerivation.indexes;
                    newDerivationLogProb[newDerivationIndex] = topQueueDerivationProb;
                } while ((topQueueDerivation = queue.addNeighboursAndPoll(topQueueDerivation)) != null && (topQueueDerivationProb = topQueueDerivation.logProb + ruleLogProb) > currentDerivationProb && ++newDerivationIndex < newDerivationSize);
                continue;
            }
            do {
                newDerivations[newDerivationIndex] = this.derivations[currentDerivationIndex];
                newDerivationLogProb[newDerivationIndex] = this.derivationLogProb[currentDerivationIndex];
                ++newDerivationIndex;
                if (this.derivations.length != ++currentDerivationIndex) continue;
                this.appendQueue(queue, topQueueDerivation, ruleLogProb, newDerivations, newDerivationLogProb, newDerivationIndex);
                return true;
            } while (topQueueDerivationProb <= (currentDerivationProb = this.derivationLogProb[currentDerivationIndex]) && newDerivationIndex < newDerivationSize);
        } while (newDerivationIndex < newDerivationSize);
        this.derivations = newDerivations;
        this.derivationLogProb = newDerivationLogProb;
        return true;
    }

    private void appendCurrentDerivations(int currentDerivationIndex, int[][] newDerivations, double[] newDerivationLogProb, int newDerivationIndex) {
        while (newDerivationIndex < newDerivations.length) {
            newDerivations[newDerivationIndex] = this.derivations[currentDerivationIndex];
            newDerivationLogProb[newDerivationIndex] = this.derivationLogProb[currentDerivationIndex];
            ++currentDerivationIndex;
            ++newDerivationIndex;
        }
        this.derivations = newDerivations;
        this.derivationLogProb = newDerivationLogProb;
    }

    private void appendLeftDerivations(int split, double ruleLogProb, int leftDerivationIndex, DerivationForest leftForest, int[][] newDerivations, double[] newDerivationLogProb, int newDerivationIndex) {
        while (newDerivationIndex < newDerivations.length) {
            newDerivations[newDerivationIndex] = new int[]{split, leftForest.root, leftDerivationIndex, -1, -1};
            newDerivationLogProb[newDerivationIndex] = leftForest.derivationLogProb[leftDerivationIndex] + ruleLogProb;
            ++leftDerivationIndex;
            ++newDerivationIndex;
        }
        this.derivations = newDerivations;
        this.derivationLogProb = newDerivationLogProb;
    }

    private void appendQueue(DerivationQueue queue, DerivationElement topQueueDerivation, double ruleLogProb, int[][] newDerivations, double[] newDerivationLogProb, int newDerivationIndex) {
        while (newDerivationIndex < newDerivations.length) {
            double topQueueDerivationProb = topQueueDerivation.logProb + ruleLogProb;
            newDerivations[newDerivationIndex] = topQueueDerivation.indexes;
            newDerivationLogProb[newDerivationIndex] = topQueueDerivationProb;
            topQueueDerivation = queue.addNeighboursAndPoll(topQueueDerivation);
            ++newDerivationIndex;
        }
        this.derivations = newDerivations;
        this.derivationLogProb = newDerivationLogProb;
    }

    public String toString() {
        String result = "";
        result = String.valueOf(result) + Arrays.toString(this.derivations[0]) + ":" + this.derivationLogProb[0];
        if (this.derivations.length > 1) {
            result = String.valueOf(result) + " ...";
        }
        return result;
    }

    public int hashCode() {
        return this.root;
    }
}

