# Some necessary packages

import numpy as np
import pandas as pd
import transformers
import torch
from torch import nn
import random
import gpustat
print(transformers.__version__)
print(torch.__version__)
print(torch.cuda.is_available())

from IPython.display import display, HTML

import re
from sklearn.model_selection import train_test_split
import datasets
from datasets import Dataset, DatasetDict
from transformers import DebertaV2Tokenizer, DebertaV2Model, DebertaV2ForSequenceClassification, TrainingArguments, Trainer, get_cosine_schedule_with_warmup, AdamW
from sklearn.metrics import f1_score, classification_report, accuracy_score
from sklearn.model_selection import ParameterGrid
import joblib
from scipy import stats
import json


import wandb
wandb.init()


task = "mnli"

# Checkpoints for loading models
model_checkpoint = "/deberta-v3-large-zeroshot-v1.1-all-33"
# model_checkpoint = "deberta-v3-base-zeroshot-v1.1-all-33"

# model_checkpoint = "deberta-v3-base-finetuned/checkpoint-1200"
# model_checkpoint = "Models/vectara_hallucination_evaluation_model"

# The output path of the trained model
output_path = 'output/'


device = torch.device('cuda:0' if torch.cuda.is_available() else 'cpu')


def print_gpu_info():
    if device == 'cpu':
        return 
    stats = gpustat.GPUStatCollection.new_query()
    for gpu in stats:
        print('GPU ID: {}'.format(gpu.index))
        print('Used Memory: {}/{}'.format(gpu.memory_used, gpu.memory_total))


# Set random seeds to ensure reproducibility
def set_seeds(seed):
    random.seed(seed)  # Set the seed for the random module to ensure consistent results
    np.random.seed(seed)  # Ensure that random numbers generated by the numpy module are consistent
    torch.manual_seed(seed)  # Set the random seed for the CPU (PyTorch)
    if torch.cuda.is_available():  # Check if CUDA (GPU) is available
        torch.cuda.manual_seed(seed)  # Set the seed for the current GPU
        torch.cuda.manual_seed_all(seed)  # Set the seed for all available GPUs

    torch.backends.cudnn.deterministic = True  # Ensure deterministic behavior of the network (fixed network structure)

set_seeds(42)




def show_random_elements(dataset, num_examples=10):
    assert num_examples <= len(dataset), "Can't pick more elements than there are in the dataset."
    picks = []
    for _ in range(num_examples):
        pick = random.randint(0, len(dataset)-1)
        while pick in picks:
            pick = random.randint(0, len(dataset)-1)
        picks.append(pick)

    df = pd.DataFrame(dataset[picks])
    for column, typ in dataset.features.items():
        if isinstance(typ, datasets.ClassLabel):
            df[column] = df[column].transform(lambda i: typ.names[i])
    display(HTML(df.to_html()))



task_to_keys = {
    "mnli": ("premise", "hypothesis")
}



# Loads a pre-trained DeBERTa-v2 tokenizer from the specified model checkpoint.
tokenizer = DebertaV2Tokenizer.from_pretrained(model_checkpoint)

def preprocess_function(examples):
    if sentence2_key is None:
        return tokenizer(examples[sentence1_key], truncation=True, max_length=256, padding='max_length')
    return tokenizer(examples[sentence1_key], examples[sentence2_key], truncation=True, max_length=256, padding='max_length')


df = pd.read_json('data/train.model-agnostic.json', lines=True)

print(df.shape)

# For rows where the task is 'DM' or 'MT', copy the 'tgt' column to itself (no changes), later we will use the tgt column as the ref column
df.loc[df['task'].isin(['DM', 'MT']), 'tgt'] = df['tgt']

# For rows where the task is 'PG', copy the 'src' column to the 'tgt' column, later we will use the tgt column as the ref column
df.loc[df['task']=='PG', 'tgt'] = df['src']

df=df[['tgt','hyp','label']]

df.columns=['tgt','hyp','label']

# We use the df as the training data
train_data = df


# Load the validation data

val_data1 = pd.read_json('data/val.model-agnostic.json')
val_data2 = pd.read_json('data/val.model-aware.v2.json')
val_data = pd.concat([val_data1, val_data2], axis=0, ignore_index=True)

task_cf = 'all'


print(val_data.shape)
val_data.loc[val_data['task'].isin(['DM', 'MT']), 'tgt'] = val_data['tgt']
val_data.loc[val_data['task']=='PG', 'tgt'] = val_data['src']

val_data=val_data[['tgt','hyp','label']]
val_data['label'].replace('Hallucination',1,inplace=True)
val_data['label'].replace('Not Hallucination',0,inplace=True)
val_data.columns=['tgt','hyp','label']

# Load two test sets
test_data_agnostic = pd.read_json('data/test.model-agnostic.json')
test_data_agnostic['label'] = 0
test_data_agnostic.loc[test_data_agnostic['task'].isin(['DM', 'MT']), 'tgt'] = test_data_agnostic['tgt']
test_data_agnostic.loc[test_data_agnostic['task']=='PG', 'tgt'] = test_data_agnostic['src']
test_data_agnostic = test_data_agnostic[['tgt','hyp','label']]
test_data_agnostic.columns=['tgt','hyp','label']

test_data_aware = pd.read_json('data/test.model-aware.json')
test_data_aware['label'] = 0
test_data_aware.loc[test_data_aware['task'].isin(['DM', 'MT']), 'tgt'] = test_data_aware['tgt']
test_data_aware.loc[test_data_aware['task']=='PG', 'tgt'] = test_data_aware['src']
test_data_aware = test_data_aware[['tgt','hyp','label']]


test_data_agnostic_all = pd.read_json('data/test.model-agnostic.json')
test_data_aware_all = pd.read_json('data/test.model-aware.json')



# Process text
# We do not perform special treatment

def clearTextFunc(text):
    # clear_text = " ".join(text.split())
    # clear_text = re.sub(r'http://[a-zA-Z0-9.?/&=:]*'," ",  clear_text)
    # clear_text = re.sub(r'https://[a-zA-Z0-9.?/&=:]*'," ",  clear_text)
    # clear_text = re.sub(r'@[a-zA-Z0-9.?/&=:]*'," ",  clear_text)
    # clear_text = re.sub(r'/s'," ",  clear_text)
    # clear_text = re.sub(r'/j'," ",  clear_text)
    # clear_text  = clear_text.lower()

    return text


def clearTexts(data,pos='tweet'):
    # Get the number of Texts based on the dataframe column size
    global num_Texts
    num_Texts = data[pos].size
    # Initialize an empty list to hold the clean Texts
    print("Cleaning and parsing the training set Texts...\n")
    # Loop over each Text; create an index i that goes from 0 to the length# of the Text list
    for i in range( 0, num_Texts ):
        # If the index is evenly divisible by 1000, print a message
        if( (i+1)%100000 == 0 ):
            print("Text %d of %d\n" % ( i+1, num_Texts ))
        # Call our function for each one, and add the result to the list of    # clean Texts
        if(str(data[pos][i])!="nan"):
            clean_train_Texts.append( clearTextFunc( data[pos][i] ) )
        else:
            clean_train_Texts.append( clearTextFunc("" ) )


# training set

clean_train_Texts = []
num_Texts = 0
clearTexts(train_data,pos='tgt')
clean_train_Texts_tgt = clean_train_Texts
num_Texts_tgt = num_Texts

clean_train_Texts = []
num_Texts = 0
clearTexts(train_data,pos='hyp')
clean_train_Texts_hyp = clean_train_Texts
num_Texts_hyp = num_Texts

label_text = train_data['label']
label_text=np.array(label_text)
label_text = label_text.reshape(num_Texts_tgt,1)
print(label_text.shape)

# Partition the data set
train_tgt=clean_train_Texts_tgt
train_hyp=clean_train_Texts_hyp
train_l=label_text



# validation set

clean_train_Texts = []
num_Texts = 0
clearTexts(val_data,pos='tgt')
clean_val_Texts_tgt = clean_train_Texts
num_Texts_tgt = num_Texts

clean_train_Texts = []
num_Texts = 0
clearTexts(val_data,pos='hyp')
clean_val_Texts_hyp = clean_train_Texts
num_Texts_hyp = num_Texts

label_text = val_data['label']
label_text=np.array(label_text)
label_text = label_text.reshape(num_Texts_tgt,1)
print(label_text.shape)

# Partition the data set
dev_tgt=clean_val_Texts_tgt
dev_hyp=clean_val_Texts_hyp
dev_label=label_text


# test set 1

clean_train_Texts = []
num_Texts = 0
clearTexts(test_data_agnostic,pos='tgt')
clean_test_Texts_tgt = clean_train_Texts
num_Texts_tgt = num_Texts

clean_train_Texts = []
num_Texts = 0
clearTexts(test_data_agnostic,pos='hyp')
clean_test_Texts_hyp = clean_train_Texts
num_Texts_hyp = num_Texts

label_text = test_data_agnostic['label']
label_text=np.array(label_text)
label_text = label_text.reshape(num_Texts_tgt,1)
print(label_text.shape)

# Partition the data set
test_data_agnostic_tgt=clean_test_Texts_tgt
test_data_agnostic_hyp=clean_test_Texts_hyp
test_data_agnostic_l=label_text

# test set 2

clean_train_Texts = []
num_Texts = 0
clearTexts(test_data_aware,pos='tgt')
clean_test_Texts_tgt = clean_train_Texts
num_Texts_tgt = num_Texts

clean_train_Texts = []
num_Texts = 0
clearTexts(test_data_aware,pos='hyp')
clean_test_Texts_hyp = clean_train_Texts
num_Texts_hyp = num_Texts

label_text = test_data_aware['label']
label_text=np.array(label_text)
label_text = label_text.reshape(num_Texts_tgt,1)
print(label_text.shape)

# Partition the data set
test_data_aware_tgt=clean_test_Texts_tgt
test_data_aware_hyp=clean_test_Texts_hyp
test_data_aware_l=label_text





dataset_all = DatasetDict({'train':Dataset.from_dict({"premise": train_tgt,"hypothesis": train_hyp,'label':train_l.reshape(-1)}),
                          'dev':Dataset.from_dict({"premise": dev_tgt,"hypothesis": dev_hyp,'label':dev_label.reshape(-1)}),
                          'test1':Dataset.from_dict({"premise": test_data_agnostic_tgt,"hypothesis": test_data_agnostic_hyp,'label':test_data_agnostic_l.reshape(-1)}),
                          'test2':Dataset.from_dict({"premise": test_data_aware_tgt,"hypothesis": test_data_aware_hyp,'label':test_data_aware_l.reshape(-1)})})
print(dataset_all)


sentence1_key, sentence2_key = task_to_keys[task]
encoded_dataset_En = dataset_all.map(preprocess_function, batched=True)

# print(encoded_dataset_En)
# encoded_dataset_En['train'].select(range(5))[0]


# Fine-tuning the model
num_labels = 2
# model1 = DebertaV2ForSequenceClassification.from_pretrained(model_checkpoint, num_labels=num_labels)


# from transformers import AutoModelForSequenceClassification, TrainingArguments, Trainer
# num_labels = 2
# model1 = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=num_labels)



# metric_name = "f1-score"  # metric_name = "accuracy"
metric_name = "accuracy"
model_name = model_checkpoint.split("/")[-1]



# evaluation function
def compute_metrics1(eval_pred):
    y_pred, y_true = eval_pred
    y_pred = np.argmax(y_pred, axis=1)
    F1 = f1_score(y_true, y_pred,labels=[0,1])
    acc = accuracy_score(y_true, y_pred)
    return{'f1-score': F1,'accuracy': acc}

# from sklearn.metrics import accuracy_score
# def compute_metrics3(eval_pred):
#     y_pred, y_true = eval_pred
#     y_pred = np.argmax(y_pred, axis=1)
#     acc = accuracy_score(y_true, y_pred)
#     return{'accuracy': acc}

from torch.nn import CrossEntropyLoss
class CustomTrainer(Trainer):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.alpha_max = 0.75 # or 0.5
        self.warmup_frac = 0.2
        self.step = 0  # Initialization step counter

    def compute_loss(self, model, inputs, return_outputs=False):
        if not model.training:
            labels = inputs.pop("labels")
            outputs = model(**inputs)
            logits = outputs.logits  # strong model logits

            # L_conf(f): CE loss
            loss_conf = CrossEntropyLoss()(logits, labels)

            return (loss_conf, outputs) if return_outputs else loss_conf

        else:
            labels = inputs.pop("labels")
            outputs = model(**inputs)
            logits = outputs.logits  # Strong model logits
            preds = torch.softmax(logits, dim=-1)

            # Strong model predictions
            mean_weak = torch.mean(labels.float(), dim=0)
            threshold = torch.quantile(preds[:, 0], mean_weak)

            # Use threshold t to harden strong model predictions
            strong_preds = torch.cat(
                [(preds[:, 0] >= threshold)[:, None], (preds[:, 0] < threshold)[:, None]],
                dim=1,
            )

            # Calculate the coefficients of the current step
            step_frac = min(self.step / (total_steps * self.warmup_frac), 1.0)
            # print(step_frac)
            coef = step_frac * self.alpha_max

            # Auxiliary target
            labels_one_hot = torch.nn.functional.one_hot(labels, num_classes=2)
            target = labels_one_hot * (1 - coef) + strong_preds.detach() * coef

            # L_conf(f): CE loss
            loss_conf = CrossEntropyLoss()(logits, target)

            self.step += 1

            return (loss_conf, outputs) if return_outputs else loss_conf

    
    # def compute_eval_loss(self, model, inputs, return_outputs=False):
    #     labels = inputs.pop("labels")
    #     outputs = model(**inputs)
    #     logits = outputs.logits  # strong model logits

    #     # L_conf(f): CE loss
    #     loss_conf = CrossEntropyLoss()(logits, labels)

    #     return (loss_conf, outputs) if return_outputs else loss_conf


    def create_optimizer_and_scheduler(self, num_training_steps: int):
        self.optimizer = AdamW(self.model.parameters(), lr=self.args.learning_rate)
        self.lr_scheduler = get_cosine_schedule_with_warmup(self.optimizer, num_warmup_steps=self.args.warmup_steps, num_training_steps=num_training_steps)
    

# train


# Define parameter grid
param_grid = {
    'learning_rate': [1e-5, 2e-5, 3e-5, 5e-5, 7e-5, 1e-4, 3e-4],
    'per_device_train_batch_size': [8],
    'per_device_eval_batch_size': [64],
    'gradient_accumulation_steps':[4, 8, 16]
    # 'weight_decay': [0.01, 0.02, 0.03, 0.05, 0.07, 0.1] # 正则化
}



print_gpu_info()

grid = ParameterGrid(param_grid)

best_metric = float('-inf')
best_model = None
best_params = None

for params in grid: 

    train_dataset = encoded_dataset_En["train"]
    val_dataset = encoded_dataset_En["dev"]

    # model
    model1 = DebertaV2ForSequenceClassification.from_pretrained(model_checkpoint, 
                                                                num_labels=num_labels)#,
                                                                # hidden_dropout_prob=0.1,  # dropout
                                                                # attention_probs_dropout_prob=0.1)  # dropout)
    
 

    model1.to(device)

    # Create new training parameters
    args = TrainingArguments(
        output_dir=f"/gm-data/{output_path}{model_name}-finetuned",
        overwrite_output_dir=True, # Automatically overwrite files under output_dir
        evaluation_strategy = "steps",
        save_strategy = "steps",
        num_train_epochs=5,
        load_best_model_at_end=True,
        metric_for_best_model=metric_name,
        logging_steps=5, # How many steps to evaluate
        save_steps=5, # How many steps to save
        save_total_limit=1, # Only save n models
        adam_beta1=0.9,
        adam_beta2=0.95,
        warmup_steps=20, # number of warmup steps
        # max_grad_norm=0.7, # Gradient clipping
        **params
    )

    steps_per_device = len(train_dataset) // args.train_batch_size
    total_steps = (steps_per_device * args.num_train_epochs) # // args.gradient_accumulation_steps

    # Create a new trainer instance
    trainer = CustomTrainer(
        model1,
        args,
        train_dataset=train_dataset,
        eval_dataset=val_dataset,
        tokenizer=tokenizer,
        compute_metrics=compute_metrics1,
        # total_steps=total_steps  # Total number of training steps
    )


    trainer.train()

    print_gpu_info()

    trainer.evaluate()

    # joblib.dump(trainer.model, '{}_model_{}.pkl'.format(output_path,task))
    # joblib.dump(trainer.model, '{}model_{}.pkl'.format(output_path, task_cf))

    # evaluate

    # Training set evaluation
    pred = trainer.predict(train_dataset)
    final_preds = np.argmax(pred[0], axis=1).tolist()

    true_y=train_dataset['label'].copy()

    print('Training set evaluation:', classification_report(true_y, final_preds))


    # Validation set evaluation
    pred = trainer.predict(val_dataset)
    final_preds = np.argmax(pred[0], axis=1).tolist()

    true_y=val_dataset['label'].copy()
    
    print(params)
    print('Validation set evaluation: ', classification_report(true_y, final_preds))

    accuracy = accuracy_score(true_y, final_preds)
    

    with open('/data/{}{}results.txt'.format(output_path, task_cf), 'a') as f:
        f.write(json.dumps({'params': params, 'accuracy': accuracy}))
        f.write('\n')
    
    if accuracy > best_metric:
        best_metric = accuracy
        best_model = trainer.model
        best_params = params






# Save the best model
# best_model.save_pretrained("path_to_save_best_model")
joblib.dump(best_model, '/gm-data/{}model_{}.pkl'.format(output_path, task_cf))
# Print optimal parameters
print(f'{task_cf} {best_metric}: Best parameters: {best_params}')



# Test set 1 output results
pred = best_model.predict(encoded_dataset_En["test1"])

test_data_agnostic_all['label'] = np.argmax(pred[0], axis=1).tolist()

exp_logits = np.exp(pred[0] - np.max(pred[0], axis=1, keepdims=True))
probabilities = exp_logits / np.sum(exp_logits, axis=1, keepdims=True)
test_data_agnostic_all['p(Hallucination)'] = probabilities[:, 1]

path_val_model_aware_output = "/gm-data/" + output_path + "test.model-agnostic.json" 
output_json = []
for i in np.arange(test_data_agnostic_all.shape[0]):
    output_label = 'Hallucination' if test_data_agnostic_all.loc[i,'label'] == 1 else 'Not Hallucination'
    prob=test_data_agnostic_all.loc[i,'p(Hallucination)']
    id=test_data_agnostic_all.loc[i,'id']
    item_to_json = {"label":output_label, "p(Hallucination)":np.float64(prob), "id":int(id)}
    output_json.append(item_to_json)
f = open(path_val_model_aware_output, 'w', encoding='utf-8')
json.dump(output_json, f)
f.close()

# Test set 1 output results
pred = best_model.predict(encoded_dataset_En["test2"])

test_data_aware_all['label'] = np.argmax(pred[0], axis=1).tolist()

exp_logits = np.exp(pred[0] - np.max(pred[0], axis=1, keepdims=True))
probabilities = exp_logits / np.sum(exp_logits, axis=1, keepdims=True)
test_data_aware_all['p(Hallucination)'] = probabilities[:, 1]

path_val_model_aware_output = "/gm-data/" + output_path + "test.model-aware.json" 
output_json = []
for i in np.arange(test_data_aware_all.shape[0]):
    output_label = 'Hallucination' if test_data_aware_all.loc[i,'label'] == 1 else 'Not Hallucination'
    prob=test_data_aware_all.loc[i,'p(Hallucination)']
    id=test_data_aware_all.loc[i,'id']
    item_to_json = {"label":output_label, "p(Hallucination)":np.float64(prob), "id":int(id)}
    output_json.append(item_to_json)
f = open(path_val_model_aware_output, 'w', encoding='utf-8')
json.dump(output_json, f)
f.close()


