from colbert import Indexer
from colbert.data import Queries
from colbert.infra import Run, RunConfig, ColBERTConfig
from colbert import Searcher


if __name__ == '__main__':
    with Run().context(RunConfig(nranks=1, experiment="msmarco")):

        config = ColBERTConfig(
            nbits=2,
            root="test_colbert/",
        )
        indexer = Indexer(checkpoint="/Users/yubowang/Downloads/colbertv2.0/", config=config)
        indexer.index(name="msmarco.nbits=2", collection="data/test_collection.tsv")

    with Run().context(RunConfig(nranks=1, experiment="msmarco")):

        config = ColBERTConfig(
            root="test_colbert/",
        )
        searcher = Searcher(index="msmarco.nbits=2", config=config)
        queries = Queries("data/test_queries.tsv")
        ranking = searcher.search_all(queries, k=100)
        ranking.save("msmarco.nbits=2.ranking.tsv")




