from api.task_manager import TaskManager
import json


class QueryExpansion:
    def __init__(self):
        self.instruction_file = r"experiments/pipeline_0724/query_expansion_instruction.txt"
        self.instruction = ""
        self.load_ins()
        self.task_manager = TaskManager()

    def load_ins(self):
        with open(self.instruction_file, "r", encoding="utf-8") as fi:
            for line in fi.readlines():
                self.instruction += line

    def expand_single_query(self, query):
        result = self.task_manager.single_query_request(self.instruction, query)
        return result


def single_test():
    expander = QueryExpansion()
    with open("/Users/2023_ubo/research/dataset/MedQA_dataset/questions/US/test.jsonl", "r") as fi:
        for i, line in enumerate(fi.readlines()):
            if i > 100:
                continue
            temp = json.loads(line)
            question = temp["question"]
            options = json.dumps(temp["options"], ensure_ascii=False)
            result = expander.expand_single_query(question + options)
            print("result", result)


if __name__ == "__main__":
    single_test()

