import os
import json
import openai

openai.api_key = 'your_openai_api_key'

def load_json_files(folder_path):
    json_data = {}
    for filename in os.listdir(folder_path):
        if filename.endswith('.json'):
            with open(os.path.join(folder_path, filename), 'r') as file:
                json_data[filename] = json.load(file)
    return json_data


def evaluate_output(instruction, model1_output, model2_output):
    prompt = f"""
You are a judge who evaluates the performance of language models. You are given an instruction and two different outputs generated by two different models. Your task is to determine which output is better. If both are equally good, state that they are equal.

Instruction: {instruction}

Output from Model 1: {model1_output}

Output from Model 2: {model2_output}

Which output is better? (Model 1, Model 2, or Equal):
"""

    response = openai.ChatCompletion.create(
        model="gpt-4o-2024-05-13",
        messages=[
            {"role": "system", "content": "You are a helpful assistant."},
            {"role": "user", "content": prompt}
        ],
        max_tokens=10,
        n=1,
        stop=None,
        temperature=0.1
    )

    return response.choices[0].text.strip()


def save_comparison_result(filename, instruction, model1_output, model2_output, result, output_dir):
    result_data = {
        'instruction': instruction,
        'model1_output': model1_output,
        'model2_output': model2_output,
        'result': result
    }
    with open(os.path.join(output_dir, filename), 'a') as file:
        json.dump(result_data, file, indent=4, ensure_ascii=False)
        file.write('\n')


def calculate_win_rate(model1, model2, output_dir):
    os.makedirs(output_dir, exist_ok=True)
    model1_wins = 0
    model2_wins = 0
    ties = 0
    total_comparisons = 0

    for filename in model1.keys():
        model1_file_data = model1[filename]
        model2_file_data = model2[filename]

        file_model1_wins = 0
        file_model2_wins = 0
        file_ties = 0
        file_total_comparisons = 0

        for model1_entry, model2_entry in zip(model1_file_data, model2_file_data):
            instruction = model1_entry['instruction']
            model1_output = model1_entry['output']
            model2_output = model2_entry['output']

            result = evaluate_output(instruction, model1_output, model2_output)
            save_comparison_result(filename, instruction, model1_output, model2_output, result, output_dir)

            if 'Model 1' in result:
                model1_wins += 1
                file_model1_wins += 1
            elif 'Model 2' in result:
                model2_wins += 1
                file_model2_wins += 1
            else:
                ties += 1
                file_ties += 1

            total_comparisons += 1
            file_total_comparisons += 1

        file_win_rate = {
            'file': filename,
            'model1_win_rate': (file_model1_wins / file_total_comparisons) * 100,
            'model2_win_rate': (file_model2_wins / file_total_comparisons) * 100,
            'tie_rate': (file_ties / file_total_comparisons) * 100
        }
        with open(os.path.join(output_dir, f'win_rate_{filename}'), 'w') as win_rate_file:
            json.dump(file_win_rate, win_rate_file, indent=4)

    model1_win_rate = (model1_wins / total_comparisons) * 100
    model2_win_rate = (model2_wins / total_comparisons) * 100
    tie_rate = (ties / total_comparisons) * 100

    overall_win_rate = {
        'model1_win_rate': (model1_wins / total_comparisons) * 100,
        'model2_win_rate': (model2_wins / total_comparisons) * 100,
        'tie_rate': (ties / total_comparisons) * 100
    }

    with open(os.path.join(output_dir, 'overall_win_rate.json'), 'w') as overall_win_rate_file:
        json.dump(overall_win_rate, overall_win_rate_file, indent=4)

    return model1_win_rate, model2_win_rate, tie_rate

model1_data = load_json_files('path_to_model1')
model2_data = load_json_files('path_to_model2')

output_dir = 'comparison_results_model1_vs_model2'
model1_win_rate, model2_win_rate, tie_rate = calculate_win_rate(model1_data, model2_data, output_dir)

print(f"Model 1 Win Rate: {model1_win_rate}%")
print(f"Model 2 Win Rate: {model2_win_rate}%")
print(f"Tie Rate: {tie_rate}%")

## TODO
# 1, model1 directory path is afri_it_model and model2 directory path is ChatGPT 4o, mT0-xxl, Aya101.
# 2, Pass the paths of model1 and model2 accordingly
# 3, Run this file.
##
