# train
export WANDB_MODE=disabled
export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7

model_name_or_path=./model/llama2/Llama-2-13b-hf
data_path=./data/train/vicuna_train_data.jsonl
output_dir=./model/vaqa_model

torchrun --nproc_per_node=8 --master_port=20011 fastchat/train/train_mem.py \
    --model_name_or_path ${model_name_or_path} \
    --data_path ${data_path} \
    --bf16 True \
    --output_dir ${output_dir} \
    --num_train_epochs 2 \
    --per_device_train_batch_size 2 \
    --per_device_eval_batch_size 2 \
    --gradient_accumulation_steps 16 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 44 \
    --save_total_limit 10 \
    --learning_rate 1e-5 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --fsdp "full_shard auto_wrap" \
    --fsdp_transformer_layer_cls_to_wrap 'LlamaDecoderLayer' \
    --tf32 True \
    --model_max_length 4096 \
    --gradient_checkpointing True \
    --lazy_preprocess True