from .extracting_by_bs4 import extracting as bs4
from .html2text import html2text

from typing import List, Dict
import re

class Extractor:
    def __init__(self):
        """
        初始化类的属性和方法
        Args:
            None
        Returns:
            None
        Raises:
            None
        """
        pass
    
    def _pre_filter(self, paragraphs):
        """
        对输入的段落进行预处理，包括：
            1. 去除长度小于50的段落；
            2. 如果段落长度大于1200，则截断为前1200个字符加上"..."；
            3. 返回经过处理后的段落列表。
        
        Args:
            paragraphs (list[str]): 一个包含多个段落的列表，每个段落都是一个str类型的字符串。
        
        Returns:
            list[str]: 经过预处理后的段落列表，每个段落都是一个str类型的字符串。
        
        """
        # sorted_paragraphs = sorted(paragraphs, key=lambda x: len(x))
        # if len(sorted_paragraphs[-1]) < 10:
        #     return []
        ret = []
        for item in paragraphs:
            item = item.strip()
            item = re.sub(r"\[\d+\]", "", item) 
            if len(item) < 50:
                continue
            if len(item) > 1200:
                item = item[:1200] + "..."
            ret.append(item)
        return ret
    
    def extract_by_bs4(self, html):
        """
        使用BeautifulSoup解析html，提取文本内容
        Args:
            html (str): 待提取的html字符串
        Returns:
            str: 提取出来的文本内容，如果提取失败则返回None
        """
        return self._pre_filter(bs4(html))
    
    def extract_by_html2text(self, html):
        """
        使用html2text库将HTML文本转换为纯文本，并进行预处理。
        
        Args:
            html (str): HTML格式的字符串。
        
        Returns:
            list[str]: 由每一行纯文本组成的列表。
        """
        return self._pre_filter(html2text(html).split("\n"))