import requests 
from time import sleep
from requests.exceptions import Timeout
import json 
import re
import traceback
from tqdm import tqdm
import os
import nltk
import sacrebleu

sleep_time= 0
def eval_python(code, testcase):
    local_var = {}
    exit_code = None
    try:
        function = ''
        if "```python" in code:
            function = code.split("```python")[1].split("```")[0] if "```" in code else code.strip(".")
        else:
            function = code.split("python```")[1].split("```")[0] if "```" in code else code.strip(".")
        function = function + "\n" + testcase
        # print(function)
        # print("-----------------------------------------------------------------------------------------------")
        # import library. Note that the library must be imported before the function is executed.
        import_lib = [i for i in function.split("\n") if i.startswith("import ") or i.startswith("from ")]
        LIBVAR = locals()
        exec("\n".join(import_lib), globals(), LIBVAR)
        GLOBALVAR = globals()
        GLOBALVAR.update(LIBVAR)

        exec("\n".join([function]), GLOBALVAR, local_var)
        exit_code = 0
        return {"exit_code": exit_code,"function": function, "input": testcase,"output":local_var["result"]}
    except KeyError as e:
        if str(e) == "'result'":
            exit_code = 0
            return {"exit_code": exit_code,"function": function,"input": testcase,"output":'<The test case does not return an output>'}
    except:
        exc_info=traceback.format_exc()
        error_line = None
        if "File \"<string>\"," in exc_info:
            pattern = r'File "<string>", line (\d+)'  
            match = re.search(pattern, exc_info)  
            
            if match:  
                line_number = match.group(1)  
                error_line=function.split("\n")[int(line_number)-1]

        # print("[KeyError]", "\n".join(traceback.format_exc().split("\n")[3:]))
        # print(f"Error line: {error_line}")
        # print(f"Code: {code}")
        exit_code = 1
        return {"exit_code": exit_code,"function": function,"input": testcase, 'output': None, "error":exc_info.strip().splitlines()[-1], "error_line": error_line}

def run_llm_direct(model_name,model,messages,temperature=0,max_tokens=3200,top_p=0.95,frequency_penalty=0.0,presence_penalty=0.0,stop=None,n=1):
    if model=="gpt-4":
        URL = ""
        headers = {"api-key": ""} 
        # sleep_time=5
    
    if model== "gpt-35-turbo-0125":
        URL = ""
        headers = {"api-key": ""} 
        

    data = { 
    "messages":messages,  
    "temperature": temperature,
    "max_tokens":max_tokens,
    "top_p":top_p,
    "frequency_penalty":frequency_penalty,
    "presence_penalty":presence_penalty,
    "stop":stop,
    } 
    # print(data)
    # r = requests.post(url = URL, headers=headers, json=data) 
    timeout = 180  
    max_retries = 5  
    retries = 0  
    
    while retries < max_retries:  
        try:  
            r = requests.post(url=URL, headers=headers, json=data, timeout=timeout)  
            break  
        except Timeout:  
            print(f"Request timed out, retrying attempt {retries + 1}...")  
            retries += 1  
    
    # 检查是否请求成功  
    if retries == max_retries:  
        print("Request failed after reaching the maximum number of retries.")  
        raise Timeout
    else:  
        data = r.json()
    data = r.json() 
    
    return data

if __name__ == "__main__":
    #   print(run_llm("gpt-4","Help me rewrite the code. I will provide the PROBLEM description, the code for this PROBLEM, and the execution result of this code. Help me rewrite it into the correct code to solve this PROBLEM.\nProblem:\nI have the following DataFrame:\n    Col1  Col2  Col3  Type\n0      1     2     3     1\n1      4     5     6     1\n2      7     8     9     2\n3    10    11    12     2\n4    13    14    15     3\n5    16    17    18     3\n\n\nThe DataFrame is read from a CSV file. All rows which have Type 1 are on top, followed by the rows with Type 2, followed by the rows with Type 3, etc.\nI would like to shuffle the order of the DataFrame's rows according to a list. \\\nFor example, give a list [2, 4, 0, 3, 1, 5] and desired result should be:\n    Col1  Col2  Col3  Type\n2      7     8     9     2\n4     13    14    15     3\n0     1     2     3     1\n3    10    11    12     2\n1     4     5     6     1\n5    16    17    18     3\n...\n\n\nHow can I achieve this?\n\n\nA:\n<code>\nimport pandas as pd\nimport numpy as np\n\n\ndf = pd.DataFrame({'Col1': [1, 4, 7, 10, 13, 16],\n                   'Col2': [2, 5, 8, 11, 14, 17],\n                   'Col3': [3, 6, 9, 12, 15, 18],\n                   'Type': [1, 1, 2, 2, 3, 3]})\nList = np.random.permutation(len(df))\n</code>\nresult = ... # put solution in this variable\nBEGIN SOLUTION\n<code>\n\n--------------------\nHere is a code snippet that may contain errors in solving the above PROBLEM:\nresult = df.iloc[List]\n\n--------------------\nThis is the code that GPT4 generated for me, here are the inputs as well as the execution results. You need to determine if the code is correct and suggest changes if it is not.\n\nThe input is:\n(   Col1  Col2  Col3  Type\n0     1     2     3     1\n1     4     5     6     1\n2     7     8     9     2\n3    10    11    12     2\n4    13    14    15     3\n5    16    17    18     3, array([5, 1, 0, 2, 3, 4], dtype=int32))\n\nUpon executing the above code, the following results were obtained:\n   Col1  Col2  Col3  Type\n5    16    17    18     3\n1     4     5     6     1\n0     1     2     3     1\n2     7     8     9     2\n3    10    11    12     2\n4    13    14    15     3\n\n\n\n\n                         \n-------------------\nThere are some rules that you must follow for rewriting the code:\n+ Is the code execution result the right answer to the PROBLEM?? If not, please rewrite the code, if yes, please do not return any code.\n+ If you need to rewrite the code:\n    + You need to first explain why the original code is incorrect.\n    + You only need to output codes that can complete the code snippet. You do not need to output the codes before and after the [insert] block or BEGIN SOLUTION block.\n    + You should answer only one code snippet, not more than one!\n+ If you do not need to rewrite the code, do not return any code, return `<original code>`.\n\n-------------------\nHere are some examples, you need to learn the format of completing the code from these examples.\n<example>\nuser:\nProblem:\nHow can I delete the last row in a numpy array?\n\nA:\n<code>\nimport numpy as np\n\narray = np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]])\n\ndef f(a=array):\n    # return the solution in this function    \n    # result = f(a)                           \n    ### BEGIN SOLUTION\n\n<code>\n### BEGIN SOLUTION\nassitant:\n    # Delete the last row\n    result = np.delete(a, -1, 0)\n    return result\n### END SOLUTION\n\n</example>\n\n\n<example>\nuser:\nProblem:\nHow can I delete the last row in a numpy array?\n\nA:\n<code>\nimport numpy as np\n\narray = np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]])\n\n</code>\nresult = ... # put solution in this variable\nBEGIN SOLUTION\n<code>\n\nassitant:\n<code>\n### BEGIN SOLUTION\n # Delete the last row\nresult = np.delete(a, -1, 0)\n### END SOLUTION\n\n</example>       \n\n-------------------\nAgain, the PROBLEM is as follows:\n\nProblem:\nI have the following DataFrame:\n    Col1  Col2  Col3  Type\n0      1     2     3     1\n1      4     5     6     1\n2      7     8     9     2\n3    10    11    12     2\n4    13    14    15     3\n5    16    17    18     3\n\n\nThe DataFrame is read from a CSV file. All rows which have Type 1 are on top, followed by the rows with Type 2, followed by the rows with Type 3, etc.\nI would like to shuffle the order of the DataFrame's rows according to a list. \\\nFor example, give a list [2, 4, 0, 3, 1, 5] and desired result should be:\n    Col1  Col2  Col3  Type\n2      7     8     9     2\n4     13    14    15     3\n0     1     2     3     1\n3    10    11    12     2\n1     4     5     6     1\n5    16    17    18     3\n...\n\n\nHow can I achieve this?\n\n\nA:\n<code>\nimport pandas as pd\nimport numpy as np\n\n\ndf = pd.DataFrame({'Col1': [1, 4, 7, 10, 13, 16],\n                   'Col2': [2, 5, 8, 11, 14, 17],\n                   'Col3': [3, 6, 9, 12, 15, 18],\n                   'Type': [1, 1, 2, 2, 3, 3]})\nList = np.random.permutation(len(df))\n</code>\nresult = ... # put solution in this variable\nBEGIN SOLUTION\n<code>\n\n\n<code>\n### BEGIN SOLUTION"))
    
    model_name = ""
    test_path = ""
    test_path = ""
    data_path = ""
    output_dir = ""
    if not os.path.exists(output_dir):
        os.makedirs(output_dir)

    output_path = output_dir + ''
    current = 0


    with open(test_path, "r") as input_file, open(output_path, "a") as output_file:
        for i,line in tqdm(enumerate(input_file)):
            if i < current :
                continue

            # if i != 0 and i % 25 == 0: sleep(5)
            sleep(0.5)

            data = json.loads(line)
            messages = data['messages']
            filtered_messages = [message for message in messages if message['role'] != 'assistant']
            # print(filtered_messages)
            response = run_llm_direct(model_name,"gpt-35-turbo-0125",filtered_messages)

            # print(response)
            code = response["choices"][0]["message"]["content"]
            output_string = {"output":code}
            # # print(code)
            # break

            sleep(sleep_time)

            # test_data = json.loads(data_lines[test_idx + i])
            # tests += '\n'.join(test_data["test_list"])
            # eval_data = eval_python(code,tests)
            output_file.write(json.dumps(output_string) + '\n')


    bleu_scores = []
    with open(output_path, "r") as predic_file, open(test_path, "r") as test_file:
        predic_lines = predic_file.readlines()
        groundtruth_lines = test_file.readlines()
        assert len(predic_lines) == len(groundtruth_lines)
        for i in range(len(predic_lines)):
            prediction = json.loads(predic_lines[i])["output"]
            groundtruth = json.loads(groundtruth_lines[i])["messages"][2]['content']

            BLEUscore = nltk.translate.bleu_score.sentence_bleu([prediction], groundtruth)
            bleu_scores.append(BLEUscore)
            # print(BLEUscore)

    print("BLEU Score: ", sum(bleu_scores)/len(bleu_scores))
