import sys
import subprocess
subprocess.check_call([sys.executable, '-m', 'pip', 'install', 'openai'])

import os
import openai
from openai import OpenAI
import time
import re
import json
from tqdm import tqdm
import pickle

def read_data():
    f = open(r'./NegotiationToM/NegotiationToM_DataSet_Final.json', encoding='utf-8')
    data = json.load(f)
    print(len(data))
    return data


def create_COTprompt(data):
    prompt = """Background: Here is a negotiation conversation for a camping trip. There are two agents who own some basic supplies and negotiate with each other to split the additional food packages, water bottles, and firewood to make their camping trip even better. Each of these items will be of either High, Medium or Low priority for these two agents. Each of the additional items only has an available quantity of 3. Please answer the following three questions using "A", "B", "C", "D"."""+"\nDialogue History:\n"+'\n'.join(data['dialogue']).replace("agent_1", "agent 1").replace("agent_2", "agent 2")+"""\nQuestion1: Based on the dialogue, what is the high preference for items Agent 2 thinks Agent 1 is?\nA.Not given\nB.Water\nC.Food\nD.Firewood\nQuestion2: Based on the dialogue, what is the medium preference for items Agent 2 thinks Agent 1 is?\nA.Not given\nB.Water\nC.Food\nD.Firewood\nQuestion3: Based on the dialogue, what is the low preference for items Agent 2 thinks Agent 1 is?\nA.Not given\nB.Water\nC.Food\nD.Firewood\nAnswer: Let’s think step by step."""
    return prompt

def running_LLMs(prompt_list, model_name, save_file_name):
    # agent2_belief_answer = []
    intents_answer_GPT4=[]
    for i in tqdm(range(len(prompt_list))):
        chat_completion = client.chat.completions.create(
        messages=[
            {
                "role": "user",
                "content": prompt_list[i],
            }
        ],
        model= model_name,)
        intents_answer_GPT4.append(chat_completion)
        
        if len(intents_answer_GPT4)%200 == 0:
            print(intents_answer_GPT4[0])
            save_response(save_file_name, intents_answer_GPT4)
        
    return intents_answer_GPT4


def save_response(save_file_name, response):
    file = open(save_file_name, 'wb')
    pickle.dump(response, file)
    file.close()

if __name__== "__main__":
    client = OpenAI(api_key=" ")
    

    dataset = read_data()
    prompt_list = []
    for i in range(len(dataset)):
        prompt_list.append(create_COTprompt(dataset[i]))
    print(prompt_list[0])
    print(len(prompt_list))
    
    model_name = "gpt-4-0613"   
#     model_name ="gpt-3.5-turbo"
    save_file_name = 'agent2_belief_answer_GPT4_COT'
    response = running_LLMs(prompt_list, model_name, save_file_name)
    save_response(save_file_name, response)
