import base64
from PIL import Image
import json
import requests
from paddleocr import PaddleOCR, draw_ocr
import os
import cv2
import numpy as np
from io import BytesIO
import numpy as np

def enlarge_box(box, delta_width, delta_height):
    rect = cv2.minAreaRect(box)   
    center, size, angle = rect
    if angle<45:
        size_new=(size[0]+delta_width,size[1]+delta_height)
    else:
        size_new=(size[0]+delta_height,size[1]+delta_width)
    new_rect = (center, size_new, angle)
    new_box = cv2.boxPoints(new_rect)
    return new_box


def Alicatu(dt_boxes,image_path):
    image_erase=cv2.imread(image_path) 
    img_height,img_width = image_erase.shape[:2]
    ocrCoordDTOList = []
    box_coordinates = np.array(dt_boxes, dtype=np.float32)
    box_coordinates=enlarge_box(box_coordinates,5,5)
    box_coordinates[:,0]=np.clip(box_coordinates[:, 0], 1, img_width-1)
    box_coordinates[:,1]=np.clip(box_coordinates[:, 1], 1, img_height-1)

     
    
    rect = cv2.minAreaRect(box_coordinates)
    center, size, angle = rect
    if angle==180:
        angle=0
    angle=angle-90
    if angle < -45:
        angle = 90 + angle
    else:
        size = (size[1], size[0])
    rotation_matrix = cv2.getRotationMatrix2D(center, angle, 1.0)
    rotated_image = cv2.warpAffine(image_erase, rotation_matrix, (image_erase.shape[1], image_erase.shape[0]), flags=cv2.INTER_CUBIC)
    rotated_rect = cv2.transform(np.array([box_coordinates]), rotation_matrix)
    M = cv2.getPerspectiveTransform(rotated_rect, box_coordinates)
    ocrCoordDTO = {
        "upLeft": {"x": int(box_coordinates[0][0]), "y": int(box_coordinates[0][1])},
        "upRight": {"x": int(box_coordinates[1][0]), "y": int(box_coordinates[1][1])},
        "downRight": {"x": int(box_coordinates[2][0]), "y": int(box_coordinates[2][1])},
        "downLeft": {"x": int(box_coordinates[3][0]), "y": int(box_coordinates[3][1])}
    }
    ocrCoordDTOList.append(ocrCoordDTO)
    is_success, buffer = cv2.imencode(".jpg", rotated_image)
    if is_success:
        image_bytes = np.array(buffer).tobytes()
    dataBase64=base64.b64encode(image_bytes)
    r = requests.post(http_url, data=payload, headers=headers)
    data = json.loads(r.text)

    data_src = json.loads(data["result"]["response"][0]["outputJson"][0])
    imgdata = base64.b64decode(data_src["tgt_image"])

    image_stream = BytesIO(imgdata)
    pil_image = Image.open(image_stream)
    cv_image = np.array(pil_image)

    image_xuanzhuan = cv2.cvtColor(cv_image, cv2.COLOR_RGB2BGR)

    warped_source = cv2.warpPerspective(image_xuanzhuan, M, (image_erase.shape[1], image_erase.shape[0]))
    mask = np.zeros(image_erase.shape[:2], dtype=np.uint8)
    cv2.fillConvexPoly(mask, box_coordinates.astype(int), 255)
    mask_3d = cv2.cvtColor(mask, cv2.COLOR_GRAY2BGR)
    image_erase = cv2.bitwise_and(image_erase, cv2.bitwise_not(mask_3d))
    warped_source = cv2.bitwise_and(warped_source, mask_3d)

    final_img = cv2.add(image_erase, warped_source)

    erased_image_path=image_path[:-4]+'_erase.png'
    cv2.imwrite(erased_image_path, final_img)

def Alicatu_evaluate(dt_boxes,image_path,save_path):
    ocrCoordDTOList = []
    box_coordinates = np.array(dt_boxes, dtype=np.float32)
    box_coordinates=enlarge_box(box_coordinates,10,10)
    image_erase=cv2.imread(image_path)  
    
    rect = cv2.minAreaRect(box_coordinates)

    center, size, angle = rect

    angle=angle-90
    if angle < -45:
        angle = 90 + angle
    else:
        size = (size[1], size[0])

    rotation_matrix = cv2.getRotationMatrix2D(center, angle, 1.0)

    rotated_image = cv2.warpAffine(image_erase, rotation_matrix, (image_erase.shape[1], image_erase.shape[0]), flags=cv2.INTER_CUBIC)

    rotated_rect = cv2.transform(np.array([box_coordinates]), rotation_matrix)

    M = cv2.getPerspectiveTransform(rotated_rect, box_coordinates)

    ocrCoordDTO = {
        "upLeft": {"x": int(box_coordinates[0][0]), "y": int(box_coordinates[0][1])},
        "upRight": {"x": int(box_coordinates[1][0]), "y": int(box_coordinates[1][1])},
        "downRight": {"x": int(box_coordinates[2][0]), "y": int(box_coordinates[2][1])},
        "downLeft": {"x": int(box_coordinates[3][0]), "y": int(box_coordinates[3][1])}
    }
    ocrCoordDTOList.append(ocrCoordDTO)
    is_success, buffer = cv2.imencode(".jpg", rotated_image)
    if is_success:
        image_bytes = np.array(buffer).tobytes()
    dataBase64=base64.b64encode(image_bytes)

    ocr_info={"ocrCoordDTOList":ocrCoordDTOList}


    data = json.loads(r.text)

    data_src = json.loads(data["result"]["response"][0]["outputJson"][0])
    imgdata = base64.b64decode(data_src["tgt_image"])

    image_stream = BytesIO(imgdata)
    pil_image = Image.open(image_stream)
    cv_image = np.array(pil_image)
    image_xuanzhuan = cv2.cvtColor(cv_image, cv2.COLOR_RGB2BGR)

    warped_source = cv2.warpPerspective(image_xuanzhuan, M, (image_erase.shape[1], image_erase.shape[0]))
    mask = np.zeros(image_erase.shape[:2], dtype=np.uint8)
    cv2.fillConvexPoly(mask, box_coordinates.astype(int), 255)
    mask_3d = cv2.cvtColor(mask, cv2.COLOR_GRAY2BGR)
    image_erase = cv2.bitwise_and(image_erase, cv2.bitwise_not(mask_3d))
    warped_source = cv2.bitwise_and(warped_source, mask_3d)
    final_img = cv2.add(image_erase, warped_source)

    image_name=(img_path.split('/'))[-1][:-4]
    erased_image_path=os.path.join(save_path,f'erase_{image_name}.png')
    cv2.imwrite(erased_image_path, final_img)
    return erased_image_path







if __name__=='__main__':
    image_path=''
    ocr = PaddleOCR(lang="en") # 首次执行会自动下载模型文件
    result = ocr.ocr(image_path)
    result=result[0]
    dt_boxes = [line[0] for line in result]
    Alicatu(dt_boxes,image_path)



