import json
from scipy.stats import stats
from typing import List, DefaultDict, Dict
import numpy as np
import random

random.seed(42)

def read_file(file_path: str):

    with open(file_path, 'r') as f:

        if '.jsonl' in file_path:
            samples = list()
            for line in f:
                samples.append(json.loads(line))

        else:
            samples = json.load(f)

    return samples


def measure_correlation(first_results: List, second_results: List):

    min_len = min(len(first_results), len(second_results))
    spearman_stats = stats.spearmanr(first_results[:min_len], second_results[:min_len])
    pearson_stats = stats.pearsonr(first_results[:min_len], second_results[:min_len])
    return {'spearman': spearman_stats.statistic, 'pearson': pearson_stats.statistic}


def find_num_human(std_1: float, std_2: float):

    return min((std_1 / std_2) ** 2, 100)


def find_distribution(samples: List):

    samples = np.array(samples)
    return samples.mean(), samples.std(), min(samples.var(), 10)


def add_elem_to_dic_list(global_dic: DefaultDict, curr_dic: Dict):

    for key in curr_dic:
        global_dic[key].append(curr_dic[key])

    return global_dic
