/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Comparators {
    public static <T> Comparator<T> chain(final Comparator<? super T> c1, final Comparator<? super T> c2) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int x = c1.compare(o1, o2);
                return x == 0 ? c2.compare(o1, o2) : x;
            }
        };
    }

    public static <T> Comparator<T> chain(final List<Comparator<? super T>> c) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int x = 0;
                Iterator it = c.iterator();
                while (x == 0 && it.hasNext()) {
                    x = ((Comparator)it.next()).compare(o1, o2);
                }
                return x;
            }
        };
    }

    public static <T> Comparator<T> chain(Comparator<? super T> ... c) {
        return Comparators.chain(Arrays.asList(c));
    }

    public static <T> Comparator<T> reverse(final Comparator<? super T> c) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int x = c.compare(o1, o2);
                return -x;
            }
        };
    }

    public static <T extends Comparable<? super T>> int nullSafeComparator(T one, T two) {
        if (one == null ^ two == null) {
            return one == null ? -1 : 1;
        }
        if (one == null && two == null) {
            return 0;
        }
        return one.compareTo(two);
    }
}

