import yaml
import os

# add the directory to path
directory = "/home/sumukshashidhar/foundry/preference-agent"


def get_config():
    with open(os.path.join(directory, "config.yaml")) as file:
        config = yaml.safe_load(file)
    return config


def print_config(config):
    print("=== HERE IS YOUR CONFIGURATION. MAKE SURE THIS LOOKS RIGHT ===")
    for key, value in config.items():
        print(f"{key}: {value}")
    print("=== END CONFIGURATION, BEGIN CODE OUTPUT ===")
    

def read_text_file(file_path):
    with open(file_path, "r") as file:
        content = file.read()
    return content

def _handle_mismatched_length(outputs, prompts):

    # Extend or truncate outputs to match the length of prompts
    if len(outputs) < len(prompts):
        print("Error: Handling Mismatched Output Length")
        outputs.extend(
            [" "] * (len(prompts) - len(outputs))
        )  # Using empty strings as default values
    elif len(outputs) > len(prompts):
        print("Error: Handling Mismatched Output Length")
        outputs = outputs[: len(prompts)]
    return outputs


def run_inference(llm, sampling_params, prompts):
    outputs = llm.generate(prompts, sampling_params)
    outputs = [i.outputs[0].text for i in outputs]
    outputs = _handle_mismatched_length(outputs, prompts)
    return outputs