theory question_87_4
imports Main

begin

typedecl entity
typedecl event

consts
  Tunicate :: "entity ⇒ bool"
  Bulbs :: "entity ⇒ bool"
  ClassifiedAs :: "entity ⇒ entity ⇒ bool"  (* corrected type *)
  Reproduce :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  SexualReproduction :: "entity ⇒ bool"

(* Explanation 1: Tunicates, which include bulbs if they are classified as such, reproduce sexually. *)
axiomatization where
  explanation_1: "∀x. Tunicate x ⟶ (∃e y. Reproduce e ∧ Agent e x ∧ Patient e y ∧ SexualReproduction y)"

(* Explanation 2: Bulbs, when classified as tunicates, can reproduce sexually. *)
axiomatization where
  explanation_2: "∀x. (Bulbs x ∧ ClassifiedAs Tunicate x) ⟶ (∃e y. Reproduce e ∧ Agent e x ∧ Patient e y ∧ SexualReproduction y)"

(* Explanation 3: Bulbs can be classified as tunicates. *)
axiomatization where
  explanation_3: "∀x. Bulbs x ⟶ ClassifiedAs x Tunicate"

theorem hypothesis:
  assumes asm: "Bulbs x"
  (* Hypothesis: Bulbs reproduce sexually. *)
  shows "∃e y. Reproduce e ∧ Agent e x ∧ Patient e y ∧ SexualReproduction y"
proof -
  from asm have "Bulbs x" by simp
  then have "ClassifiedAs x Tunicate" using explanation_3 by blast
  then have "∃e y. Reproduce e ∧ Agent e x ∧ Patient e y ∧ SexualReproduction y" using explanation_2 by blast
  then show ?thesis by simp
qed

end
