theory question_81_5
imports Main

begin
typedecl entity
typedecl event

consts
  Person :: "entity ⇒ bool"
  Ground :: "entity ⇒ bool"
  Soaring :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Bicycle :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"
  Bike :: "entity ⇒ bool"
  CanHave :: "entity ⇒ bool"
  CanRide :: "entity ⇒ bool"
  Helmet :: "entity ⇒ bool"
  Skyline :: "entity ⇒ bool"
  Lake :: "entity ⇒ bool"
  Wears :: "event ⇒ entity ⇒ entity ⇒ bool"
  Jumps :: "event ⇒ bool"
  InFrontOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A person is outside if they are soaring over any ground. *)
axiomatization where
  explanation_1: "∀x z e. Person x ∧ Ground z ∧ Soaring e ∧ Agent e x ∧ Patient e z ⟶ Outside x"

(* Explanation 2: A person has a bike if they are on a bicycle. *)
axiomatization where
  explanation_2: "∀x y. Person x ∧ Bicycle y ∧ On x y ⟶ Has x y"

(* Explanation 3: A bike is a type of bicycle that a person can have and ride. *)
axiomatization where
  explanation_3: "∀x. Bike x ⟶ Bicycle x ∧ CanHave x ∧ CanRide x"

theorem hypothesis:
  (* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
  assumes asm: "Person x ∧ Bicycle y ∧ Helmet z ∧ Skyline w ∧ Lake w ∧ Wears e1 x z ∧ Agent e1 x ∧ Jumps e2 ∧ Agent e2 x ∧ Soaring e3 ∧ Agent e3 x ∧ Patient e3 w ∧ On x y ∧ InFrontOf x w"
  (* Hypothesis: A person is outside with a bike. *)
  shows "∃x y. Person x ∧ Bike y ∧ Outside x ∧ Has x y"
proof -
  {
    assume "Person x ∧ Bicycle y ∧ Helmet z ∧ Skyline w ∧ Lake w ∧ Wears e1 x z ∧ Agent e1 x ∧ Jumps e2 ∧ Agent e2 x ∧ Soaring e3 ∧ Agent e3 x ∧ Patient e3 w ∧ On x y ∧ InFrontOf x w"
    then have "Person x" by blast
    moreover have "Soaring e3 ∧ Agent e3 x ∧ Patient e3 w ∧ Ground w" using asm by blast
    ultimately have "Outside x" using explanation_1 by blast
    moreover have "Bicycle y ∧ On x y" by blast
    ultimately have "Has x y" using explanation_2 by blast
    moreover have "Bike y ∧ Bicycle y ∧ CanHave y ∧ CanRide y" using asm by blast
    ultimately show "∃x y. Person x ∧ Bike y ∧ Outside x ∧ Has x y" by blast
  }
qed

end
