theory question_36_5
imports Main

begin
typedecl entity
typedecl event
typedecl season

consts
  BusyCityStreet :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Many :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  AtTheSameTime :: "entity ⇒ entity ⇒ bool"
  Walking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Winter :: "season ⇒ bool"
  Down :: "event ⇒ bool"
  In :: "event ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: A busy city street is a street that has many people on it at the same time. *)
axiomatization where
  explanation_1: "∀x. BusyCityStreet x ⟷ (Street x ∧ ∃y. People y ∧ Many y ∧ On y x ∧ AtTheSameTime y x)"

(* Explanation 2: People who are walking are located on a street. *)
axiomatization where
  explanation_2: "∀x y e. People x ∧ Walking e ∧ Agent e x ⟶ ∃z. Street z ∧ On x z"

theorem hypothesis:
  (* Premise: People walking down a busy city street in the winter. *)
  assumes asm: "People x ∧ Walking e ∧ Agent e x ∧ BusyCityStreet z ∧ Down e ∧ In e x z ∧ Winter y"
  (* Hypothesis: The street has a lot of people. *)
  shows "∃x y. Street x ∧ People y ∧ Many y ∧ On y x"
proof -
  from asm have "BusyCityStreet z" by blast
  from this have "Street z ∧ ∃y. People y ∧ Many y ∧ On y z ∧ AtTheSameTime y z" using explanation_1 by blast
  then obtain y where "People y ∧ Many y ∧ On y z ∧ AtTheSameTime y z" by blast
  show ?thesis using `Street z` `People y` `Many y` `On y z` by blast
qed

end
