theory question_91_3

imports Main

begin

typedecl entity
typedecl event

consts
 Child :: "entity ⇒ bool"
 Playing :: "event ⇒ bool"
 EngageIn :: "event ⇒ entity ⇒ bool"
 Outside :: "entity ⇒ bool"

(* Explanation 1: Children play. *)
axiomatization where
 explanation_1: "∀x. Child x ⟶ Playing x"

(* Explanation 2: When children play, they engage in the act of playing. *)
axiomatization where
 explanation_2: "∀x y e. Child x ∧ Playing y ∧ EngageIn e x y"

theorem hypothesis:
 (* Premise: Several children playing outside. *)
 assumes asm: "Child x  ∧ Outside y  ∧ Playing e  ∧ Agent e  x "
 (* Hypothesis: There are children playing. *)
 shows "∃x e. Child x  ∧ Playing e  ∧ Agent e  x "
proof -
 from asm have "Child x" by blast
 then have "Playing e" using explanation_1 by blast
 then show ?thesis using `Child x` `Playing e` by blast
qed

end
