theory question_75_0

imports Main

begin

typedecl entity
typedecl event

consts
  ExtremeHeat :: "entity ⇒ bool"
  Pressure :: "entity ⇒ bool"
  Rock :: "entity ⇒ bool"
  Change :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Marble :: "entity ⇒ bool"
  MetamorphicRock :: "entity ⇒ bool"

(* Explanation 1: Extreme heat and pressure change rock into metamorphic rock. *)
axiomatization where
  explanation_1: "∀x y z e. ExtremeHeat x ∧ Pressure y ∧ Rock z ∧ Change e ∧ Agent e x ∧ Agent e y ∧ Patient e z ⟶ MetamorphicRock z"

(* Explanation 2: Marble is a form of metamorphic rock. *)
axiomatization where
  explanation_2: "∀x. Marble x ⟶ MetamorphicRock x"  

theorem hypothesis:
  assumes asm: "ExtremeHeat x ∧ Pressure y ∧ Rock z ∧ Change e ∧ Agent e x ∧ Agent e y ∧ Patient e z"
  (* Hypothesis: Extreme heat and pressure change rock into marble. *)
  shows "Marble z"
proof -
  from asm have "ExtremeHeat x ∧ Pressure y ∧ Rock z ∧ Change e ∧ Agent e x ∧ Agent e y ∧ Patient e z" by simp
  then have "MetamorphicRock z" using explanation_1 by blast
  then have "Marble z" using explanation_2 by blast
  show ?thesis using `Marble z` by blast
qed

end
