theory question_49_0

imports Main

begin
typedecl entity
typedecl event

consts
  Group :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Costumes :: "entity ⇒ bool"
  Wearing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Of :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A group means that there are people. *)
axiomatization where
  explanation_1: "∀x. Group x ⟶ People x"

theorem hypothesis:
  (* Premise: A group of people are wearing costumes. *)
  assumes asm: "Group x ∧ People y ∧ Costumes z ∧ Wearing e ∧ Agent e y ∧ Patient e z ∧ Of y x"
  (* Hypothesis: People are wearing costumes. *)
  shows "∃x y e. People x ∧ Costumes y ∧ Wearing e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Group x" by blast
  then have "People x" using explanation_1 by blast
  from asm have "Costumes z ∧ Wearing e ∧ Agent e x ∧ Patient e z" by blast
  then show ?thesis using `People x` by blast
qed

end
