theory question_89_8
imports Main

begin
typedecl entity
typedecl event

consts
  Forest :: "entity ⇒ bool"
  Woods :: "entity ⇒ bool"
  Bicycling :: "event ⇒ bool"
  Through :: "event ⇒ bool"
  Autumn :: "entity ⇒ bool"
  MountainBiking :: "event ⇒ bool"
  EarlyFall :: "entity ⇒ bool"
  In :: "event ⇒ entity ⇒ bool"
  During :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Forests contain woods. *)
axiomatization where
  explanation_1: "∀x. Forest x ⟶ Woods x"

(* Explanation 2: Woods are part of forests. *)
axiomatization where
  explanation_2: "∀x. Woods x ⟶ Forest x"

theorem hypothesis:
  (* Premise: Mountain biking in a forest during the early fall. *)
  assumes asm: "MountainBiking e ∧ In e x ∧ Forest x ∧ EarlyFall y ∧ During e y"
  (* Hypothesis: Bicycling through the woods in the Autumn. *)
  shows "∃x y z e. Bicycling e ∧ Through e ∧ Woods x ∧ Autumn y ∧ In e x ∧ In e z"
proof -
  from asm have "MountainBiking e ∧ In e x ∧ Forest x ∧ EarlyFall y ∧ During e y" by blast
  then have "Woods x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
