import matplotlib.pyplot as plt
from matplotlib.pyplot import savefig
import numpy as np
from matplotlib.pyplot import MultipleLocator
  
# initialize x and y coordinates 
# AULA-CP
# bias_score = [56.5,54.24,48.14,42.64,46.49,47.28,46.09,45.89,49.01,47.88,50.53,47.61,47.88,48.41,41.91,48.14,42.9,47.35,45.56,52.12]
# age = [59.77,40.23,50.57,44.83,52.87,51.72,51.72,57.47,44.83,47.13,43.68,56.32,59.77,43.68,44.83,42.53,41.38,44.83,39.08,45.98]
# disability = [41.67,25,23.33,20,20,23.33,43.33,41.67,36.67,40,43.33,56.67,50,41.67,41.67,58.33,58.33,48.33,50,46.67]
# gender= [48.09,48.09,43.13,45.8,46.18,43.13,43.51,41.6,43.51,45.04,47.33,45.42,44.27,46.56,42.37,50.76,46.18,47.71,44.66,51.53]
# nationality = [58.49,61.01,47.17,53.46,42.77,45.28,44.65,43.4,45.91,42.77,44.65,45.28,40.88,37.74,40.88,57.23,52.2,53.46,49.69,61.01]
# physical_appearance = [36.51,42.86,38.1,39.68,31.75,50.79,42.86,55.56,50.79,52.38,53.97,63.49,49.21,50.79,36.51,49.21,50.79,47.62,53.97,52.38]
# race_color = [65.5,57.95,53.49,32.36,53.29,54.26,52.13,44.96,59.11,48.84,56.59,46.9,55.43,56.2,42.83,46.51,35.85,47.87,42.64,58.53]
# religion = [39.05,59.05,33.33,35.24,50.48,37.14,30.48,32.38,30.48,36.19,39.05,38.1,33.33,31.43,32.38,36.19,53.33,52.38,31.43,36.19]
# sexual_orientation = [53.57,64.29,71.43,59.52,50,47.62,54.76,66.67,64.29,66.67,65.48,64.29,57.14,58.33,22.62,46.43,41.67,29.76,61.9,46.43]
# socioeconomic = [63.37,59.88,49.42,62.79,37.21,45.35,37.79,47.67,39.53,53.49,47.09,39.53,34.3,47.09,55.23,47.67,37.21,45.93,51.16,43.02]

# AULA-SS
bias_score = [51.85,50,51.61,49.62,49.29,50.05,48.34,49.34,47.91,51.23,50.71,48.96,49.91,49.05,51.52,48.39,50.14,50.33,50.62,49.95]
gender = [54.9,43.53,49.41,44.71,50.2,44.31,42.75,42.35,40.78,52.55,50.2,52.55,48.24,48.24,52.55,47.45,49.8,47.84,49.02,45.88]
profession = [50,47.65,51.73,48.52,49.38,49.38,46.42,49.14,49.51,49.75,52.22,48.52,51.85,52.35,51.85,52.84,54.57,52.84,54.81,50.37]
race = [52.6,52.29,51.66,51.46,47.71,51.04,50.1,50.31,46.88,51.14,48.86,47.71,48.23,46.15,51.85,45.63,46.36,49.06,47.61,49.38]
religion = [51.9,67.09,56.96,54.43,64.56,63.29,64.56,62.03,67.09,63.29,59.49,56.96,55.7,53.16,48.1,39.24,51.9,48.1,49.37,65.82]

time = ['1810', '1820', '1830', '1840', '1850', '1860', '1870',
 '1880', '1890', '1900', '1910','1920','1930','1940','1950','1960','1970','1980','1990','2000']

# plot scatter plot with x and y data 
plt.figure(figsize=(12, 6), dpi=200)

plt.scatter(time, bias_score)

## CP
# plt.scatter(time, age) 
# plt.scatter(time, disability)
# plt.scatter(time, gender)
# plt.scatter(time, nationality)
# plt.scatter(time, physical_appearance)
# plt.scatter(time, race_color)
# plt.scatter(time, religion)
# plt.scatter(time, sexual_orientation)
# plt.scatter(time, socioeconomic)


# plot with x and y data 
plt.plot(time, bias_score, label='bias score')

## CP
# plt.plot(time, age, label='age')
# plt.plot(time, disability, label='disability')
# plt.plot(time, gender, label='gender')
# plt.plot(time, nationality, label='nationality')
# plt.plot(time, physical_appearance, label='physical appearance')
# plt.plot(time, race_color, label='race color')
# plt.plot(time, religion, label='religion')
# plt.plot(time, sexual_orientation, label='sexual orientation')
# plt.plot(time, socioeconomic, label='socioeconomic')
# plt.ylim(10, 80)

## SS
plt.scatter(time, gender)
plt.scatter(time, profession)
plt.scatter(time, race)
plt.scatter(time, religion)

plt.plot(time, gender, label='gender')
plt.plot(time, profession, label='profession')
plt.plot(time, race, label='race')
plt.plot(time, religion, label='religion')

# y_major_locator = MultipleLocator(5)
# ax = plt.gca()
# ax.yaxis.set_major_locator(y_major_locator)
# plt.ylim(45, 65)

plt.xticks(rotation=30, size = 9)

# plt.legend(loc="upper right", bbox_to_anchor=(1.40, 0.95))
# plt.legend(loc="upper right", bbox_to_anchor=(1.26, 0.95))
plt.legend(loc="upper right",  fontsize=10, ncol=2)
plt.ylabel('AULA-SS', fontsize=12)


path = 'results/aula-ss-coha.png'
savefig(path, dpi=None, facecolor='w', edgecolor='w',
        orientation='portrait',
        transparent=False, bbox_inches='tight', pad_inches=0.1, metadata=None)

