import re
import json
from pathlib import Path
import torch
from typing import List, Dict, Any, Sequence, Tuple
import pandas as pd


def make_intent_mapping(data_meta_folder: str) -> None:
    data = json.load(
        Path(data_meta_folder, 'intent_descriptions.json').open('r'))
    intent2idx = {intent: intent_id for intent_id,
                  intent in enumerate(sorted(data.keys()))}
    idx2intent = {intent_id: intent for intent,
                  intent_id, in intent2idx.items()}
    json.dump(intent2idx, Path(data_meta_folder, 'intent2idx.json').open('w'))
    json.dump(idx2intent, Path(data_meta_folder, 'idx2intent.json').open('w'))


def get_intent_info(data_meta_folder: str) -> Tuple[List[str], List[str]]:
    data = json.load(
        Path(data_meta_folder, 'intent_descriptions.json').open('r'))
    intent2idx = {intent: intent_id for intent_id,
                  intent in enumerate(sorted(data.keys()))}
    intent_descriptions = list()
    for intent in intent2idx.keys():
        intent_descriptions.append(data[intent])
    return list(intent2idx.keys()), intent_descriptions


def get_intent_descriptions(data_meta_folder: str) -> List[str]:
    data = json.load(
        Path(data_meta_folder, 'intent_descriptions.json').open('r'))
    intent2idx = {intent: intent_id for intent_id,
                  intent in enumerate(sorted(data.keys()))}
    intent_descriptions = list()
    for intent in intent2idx.keys():
        intent_descriptions.append(data[intent])
    return intent_descriptions


def get_data(data_path: str) -> Dict[str, List[str]]:
    if data_path.endswith('.csv'):
        data = pd.read_csv(data_path)
        texts = data['text'].tolist()
        labels = data['intents'].tolist()
        return {"text": texts, 'labels': labels}
    else:
        raise NotImplementedError
