#! /usr/bin/env sh
#set -xe
 
CURDIR=$(cd $(dirname $0); pwd)

TRAIN_DATA_PATH=/XXX/XXX
DEV_DATA_PATH=/XXX/XXX
    ### examples see the folder ./examples_train_data/example_roberta_ids.txt

sent_encoder_folder=bert-base-uncased     ## or the folder the initial model is placed
def_encoder_folder=bert-base-uncased

OUT_DIR=/XXX/XXX


batch_size=48  ## for BERT 48, for RoBERTa 36, limit due to the OOM error 
usr_roberta=1  ## use roberta or bert 

python3  train.py \
    --train_set $TRAIN_DATA_PATH  \
    --dev_set $DEV_DATA_PATH \
    --model_dir $OUT_DIR  \
    --batch_size $batch_size \
    --max_len 128 \
    --n_epoch 10 \
    --patience 10 \
    --lr 2e-5 \
    --cold_steps_count  0 \
    --fine_tune 0 \
    --sent_encoder_folder=$sent_encoder_folder  \
    --def_encoder_folder=$def_encoder_folder  \
    --usr_roberta $usr_roberta \
    --gloss_weight 1 \
    --mlm_weight 0.5 \