from scipy.stats import pearsonr, spearmanr
from sklearn.metrics import matthews_corrcoef, f1_score

def simple_accuracy(preds, labels):
    return (preds == labels).mean()

def acc_and_f1(preds, labels):
    acc = simple_accuracy(preds, labels)
    f1 = f1_score(y_true=labels, y_pred=preds)
    return {
        "main": acc,
        "acc": acc,
        "f1": f1,
        "acc_and_f1": (acc + f1) / 2,
    }

def metric(task, preds, labels):
    #print (preds, labels, task)
    if task == "LCQMC":
        result = acc_and_f1(preds, labels)
    else:
        result = {
            "acc": simple_accuracy(preds, labels),
            "main": simple_accuracy(preds, labels),
        }
    return result
