#!/usr/bin/env bash

cd ../ClozeGenerators

# rm -r /nas/home/qasemi/Mowgli-CoreQuisite/outputs/DICE/*

ALLPRED=(
       /r/UsedFor
#        /r/CapableOf
#        /r/Desires
#        /r/CausesDesire
#        /r/Causes
#        /r/RelatedTo /r/IsA /r/PartOf /r/Desires /r/NotDesires /r/CreatedBy /r/MannerOf
)
ALLMODELS=(
    bert-large-cased
    roberta-base
    gpt2
    facebook/bart-large
    xlm-roberta-large
    transfo-xl-wt103
)
for PREDICATE in ${ALLPRED[*]};
do
    for MODEL in ${ALLMODELS[*]};
    do
        MYNAME=${PREDICATE/\/r\//}_${MODEL/\//_}
        python KGLexicGenerator.py \
            graph_path=/nas/home/qasemi/mowgli/cskg/V4/output_v004/conceptnet/graph.graphml \
            max_len=-1 \
            lexic='Base' \
            perplexity=true \
            perplexity_model=${MODEL} \
            predicates=["${PREDICATE}"] \
            hydra.run.dir=/nas/home/qasemi/Mowgli-CoreQuisite/outputs/KG/${MYNAME}

#         exit
    done
done
# graph_path=/nas/home/qasemi/mowgli-cache/DICE/conceptnet-dice.csv \